/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Color;
import org.jfree.pixie.wmf.GDIColor;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdAnimatePalette
extends MfCmd {
    private static final int POS_START_ANIMATE_COLOR = 0;
    private static final int POS_CENTRIES = 1;
    private static final int POS_START_ENTRIES = 2;
    private int posStartAnimate;
    private Color[] colors;

    public Color[] getEntries() {
        return this.colors;
    }

    public int getEntriesCount() {
        if (this.colors == null) {
            return 0;
        }
        return this.colors.length;
    }

    public int getFunction() {
        return 1078;
    }

    public MfCmd getInstance() {
        return new MfCmdAnimatePalette();
    }

    public int getPosStartAnimate() {
        return this.posStartAnimate;
    }

    public MfRecord getRecord() throws RecordCreationException {
        int n = this.getEntriesCount();
        if (n == 0) {
            throw new RecordCreationException("Empty AnimatePaletteRecord is not valid");
        }
        MfRecord mfRecord = new MfRecord(2 + n * 2);
        mfRecord.setParam(0, this.getPosStartAnimate());
        mfRecord.setParam(1, n);
        Color[] colorArray = new Color[n];
        int n2 = 0;
        while (n2 < n) {
            Color color = colorArray[n2];
            mfRecord.setLongParam(n2 * 2 + 2, GDIColor.translateColor(color));
            ++n2;
        }
        return mfRecord;
    }

    public void replay(WmfFile wmfFile) {
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }

    public void setEntries(Color[] colorArray) {
        this.colors = colorArray;
    }

    public void setPosStartAnimate(int n) {
        if (this.posStartAnimate < 0) {
            throw new IndexOutOfBoundsException("Palette indices must be positive.");
        }
        this.posStartAnimate = n;
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        this.setPosStartAnimate(n);
        int n2 = mfRecord.getParam(1);
        Color[] colorArray = new Color[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = mfRecord.getLongParam(n3 * 2 + 2);
            GDIColor gDIColor = new GDIColor(n4);
            colorArray[n3] = gDIColor;
            ++n3;
        }
        this.setEntries(colorArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ANIMATE_PALETTE] posStartAnimate=");
        stringBuffer.append(this.getPosStartAnimate());
        stringBuffer.append(" entriesCount=");
        stringBuffer.append(this.getEntriesCount());
        return stringBuffer.toString();
    }
}

