/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdBitBlt
extends MfCmd {
    private static final int POS_ROP = 0;
    private static final int POS_Y_SOURCE_ORIGIN = 1;
    private static final int POS_X_SOURCE_ORIGIN = 2;
    private static final int POS_DESTINATION_Y_EXT = 3;
    private static final int POS_DESTINATION_X_EXT = 4;
    private static final int POS_Y_DESTINATION_ORIGIN = 5;
    private static final int POS_X_DESTINATION_ORIGIN = 6;
    private static final int POS_BITMAP_WIDTH = 7;
    private static final int POS_BITMAP_HEIGHT = 8;
    private static final int POS_BYTES_PER_RASTER_LINE = 9;
    private static final int POS_COLOR_PLANES_BITMAP = 10;
    private static final int POS_ADJACENT_COLOR_BITS = 11;
    private static final int POS_DEVICE_DEPENDENT_BITMAP_BITS = 12;
    private int rop;
    private int sourceY;
    private int sourceX;
    private int destXExt;
    private int destYExt;
    private int destXOrigin;
    private int destYOrigin;
    private int bitmapWidth;
    private int bitmapHeight;
    private int bytesPerRasterLine;
    private int colorPlanesBitmap;
    private int adjacentColorBits;
    private byte[] deviceDependentBitmap;

    public int getAdjacentColorBits() {
        return this.adjacentColorBits;
    }

    public int getBitmapHeight() {
        return this.bitmapHeight;
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public int getBytesPerRasterLine() {
        return this.bytesPerRasterLine;
    }

    public int getColorPlanesBitmap() {
        return this.colorPlanesBitmap;
    }

    public int getDestXExt() {
        return this.destXExt;
    }

    public int getDestXOrigin() {
        return this.destXOrigin;
    }

    public int getDestYExt() {
        return this.destYExt;
    }

    public int getDestYOrigin() {
        return this.destYOrigin;
    }

    public byte[] getDeviceDependentBitmap() {
        return this.deviceDependentBitmap;
    }

    public int getFunction() {
        return 2338;
    }

    public MfCmd getInstance() {
        return new MfCmdBitBlt();
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord mfRecord = new MfRecord(12 + this.deviceDependentBitmap.length / 4);
        mfRecord.setParam(0, this.getRop());
        mfRecord.setParam(1, this.getSourceX());
        mfRecord.setParam(2, this.getSourceY());
        mfRecord.setParam(4, this.getDestXExt());
        mfRecord.setParam(3, this.getDestYExt());
        mfRecord.setParam(6, this.getDestXOrigin());
        mfRecord.setParam(5, this.getDestYOrigin());
        mfRecord.setParam(7, this.getBitmapWidth());
        mfRecord.setParam(8, this.getBitmapHeight());
        mfRecord.setParam(9, this.getBytesPerRasterLine());
        mfRecord.setParam(10, this.getColorPlanesBitmap());
        mfRecord.setParam(11, this.getAdjacentColorBits());
        return mfRecord;
    }

    public int getRop() {
        return this.rop;
    }

    public int getSourceX() {
        return this.sourceX;
    }

    public int getSourceY() {
        return this.sourceY;
    }

    public void replay(WmfFile wmfFile) {
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }

    public void setAdjacentColorBits(int n) {
        this.adjacentColorBits = n;
    }

    public void setBitmapHeight(int n) {
        this.bitmapHeight = n;
    }

    public void setBitmapWidth(int n) {
        this.bitmapWidth = n;
    }

    public void setBytesPerRasterLine(int n) {
        this.bytesPerRasterLine = n;
    }

    public void setColorPlanesBitmap(int n) {
        this.colorPlanesBitmap = n;
    }

    public void setDestXExt(int n) {
        this.destXExt = n;
    }

    public void setDestXOrigin(int n) {
        this.destXOrigin = n;
    }

    public void setDestYExt(int n) {
        this.destYExt = n;
    }

    public void setDestYOrigin(int n) {
        this.destYOrigin = n;
    }

    public void setDeviceDependentBitmap(byte[] byArray) {
        this.deviceDependentBitmap = byArray;
    }

    public void setRecord(MfRecord mfRecord) {
        this.setRop(mfRecord.getParam(0));
        this.setSourceX(mfRecord.getParam(1));
        this.setSourceY(mfRecord.getParam(2));
        this.setDestXExt(mfRecord.getParam(4));
        this.setDestYExt(mfRecord.getParam(3));
        this.setDestXOrigin(mfRecord.getParam(6));
        this.setDestYOrigin(mfRecord.getParam(5));
        this.setBitmapWidth(mfRecord.getParam(7));
        this.setBitmapHeight(mfRecord.getParam(8));
        this.setBytesPerRasterLine(mfRecord.getParam(9));
        this.setColorPlanesBitmap(mfRecord.getParam(10));
        this.setAdjacentColorBits(mfRecord.getParam(11));
    }

    public void setRop(int n) {
        this.rop = n;
    }

    public void setSourceX(int n) {
        this.sourceX = n;
    }

    public void setSourceY(int n) {
        this.sourceY = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[OLD_BIT_BLT]");
        return stringBuffer.toString();
    }
}

