/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Color;
import org.jfree.pixie.wmf.GDIColor;
import org.jfree.pixie.wmf.MfLogBrush;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.util.Log;

public class MfCmdCreateBrush
extends MfCmd {
    private static final int PARAM_STYLE = 0;
    private static final int PARAM_COLOR = 1;
    private static final int PARAM_HATCH = 3;
    private static final int RECORD_SIZE = 4;
    private int style;
    private Color color;
    private int hatch;

    public Color getColor() {
        return this.color;
    }

    public int getFunction() {
        return 764;
    }

    public int getHatch() {
        return this.hatch;
    }

    public MfCmd getInstance() {
        return new MfCmdCreateBrush();
    }

    public MfRecord getRecord() {
        MfRecord mfRecord = new MfRecord(4);
        mfRecord.setParam(0, this.getStyle());
        mfRecord.setLongParam(1, GDIColor.translateColor(this.getColor()));
        mfRecord.setParam(3, this.getHatch());
        return mfRecord;
    }

    public int getStyle() {
        return this.style;
    }

    public void replay(WmfFile wmfFile) {
        MfLogBrush mfLogBrush = new MfLogBrush();
        mfLogBrush.setStyle(this.getStyle());
        mfLogBrush.setColor(this.getColor());
        mfLogBrush.setHatchedStyle(this.getHatch());
        wmfFile.getCurrentState().setLogBrush(mfLogBrush);
        wmfFile.storeObject(mfLogBrush);
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setHatch(int n) {
        if (n != 5 && n != 8 && n != 6 && n != 2 && n != 1 && n != 4 && n != 9 && n != 1 && n != 3 && n != 7 && n != 0) {
            throw new IllegalArgumentException("The specified pattern is invalid");
        }
        this.hatch = n;
    }

    public void setRecord(MfRecord mfRecord) {
        if (mfRecord.getLength() != 14) {
            Log.warn((Object)"Unknown type of CreateBrushIndirect encountered.");
        }
        int n = mfRecord.getParam(0);
        int n2 = mfRecord.getLongParam(1);
        int n3 = mfRecord.getParam(3);
        this.setStyle(n);
        this.setColor(new GDIColor(n2));
        this.setHatch(n3);
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CREATE_BRUSH] style=");
        stringBuffer.append(this.getStyle());
        stringBuffer.append(" color=");
        stringBuffer.append(this.getColor());
        stringBuffer.append(" hatch=");
        stringBuffer.append(this.getHatch());
        return stringBuffer.toString();
    }
}

