/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import org.jfree.pixie.wmf.MfLogFont;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;

public class MfCmdCreateFont
extends MfCmd {
    public static final int CHARSET_ANSI = 0;
    public static final int CHARSET_DEFAULT = 1;
    public static final int CHARSET_SYMBOL = 2;
    public static final int CHARSET_SHIFTJIS = 128;
    public static final int CHARSET_OEM = 255;
    private static int FONT_FACE_MAX = 31;
    private static int FIXED_RECORD_SIZE = 9;
    private static int POS_HEIGHT = 0;
    private static int POS_WIDTH = 1;
    private static int POS_ESCAPEMENT = 2;
    private static int POS_ORIENTATION = 3;
    private static int POS_WEIGHT = 4;
    private static int POS_FLAGS1 = 5;
    private static int POS_FLAGS2 = 6;
    private static int POS_PRECISION = 7;
    private static int POS_QUALITY = 8;
    private static int POS_FONTFACE = 9;
    private int height;
    private int width;
    private int scaled_height;
    private int scaled_width;
    private int escapement;
    private int orientation;
    private int weight;
    private boolean italic;
    private boolean underline;
    private boolean strikeout;
    private int charset;
    private int outprecision;
    private int clipprecision;
    private int quality;
    private int pitchAndFamily;
    private String facename;

    private int formFlags(boolean bl, boolean bl2) {
        int n = 0;
        if (bl) {
            n += 256;
        }
        if (bl2) {
            ++n;
        }
        return n;
    }

    public int getCharset() {
        return this.charset;
    }

    public int getClipPrecision() {
        return this.clipprecision;
    }

    public int getEscapement() {
        return this.escapement;
    }

    public String getFontFace() {
        return this.facename;
    }

    public int getFunction() {
        return 763;
    }

    public int getHeight() {
        return this.height;
    }

    public MfCmd getInstance() {
        return new MfCmdCreateFont();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getOutputPrecision() {
        return this.outprecision;
    }

    public int getPitchAndFamily() {
        return this.pitchAndFamily;
    }

    public int getQuality() {
        return this.quality;
    }

    public MfRecord getRecord() {
        String string = this.getFontFace();
        if (string.length() > FONT_FACE_MAX) {
            string = string.substring(0, FONT_FACE_MAX);
        }
        MfRecord mfRecord = new MfRecord(FIXED_RECORD_SIZE + string.length());
        mfRecord.setParam(POS_HEIGHT, this.getHeight());
        mfRecord.setParam(POS_WIDTH, this.getWidth());
        mfRecord.setParam(POS_ESCAPEMENT, this.getEscapement());
        mfRecord.setParam(POS_ORIENTATION, this.getOrientation());
        mfRecord.setParam(POS_WEIGHT, this.getWeight());
        mfRecord.setParam(POS_FLAGS1, this.formFlags(this.isUnderline(), this.isItalic()));
        mfRecord.setParam(POS_FLAGS2, this.formFlags(this.isStrikeout(), false) + this.getCharset());
        mfRecord.setParam(POS_PRECISION, this.getOutputPrecision() << 8 + this.getClipPrecision());
        mfRecord.setParam(POS_QUALITY, this.getQuality() << 8 + this.getPitchAndFamily());
        mfRecord.setStringParam(POS_FONTFACE, string);
        return mfRecord;
    }

    public int getScaledHeight() {
        return this.scaled_height;
    }

    public int getScaledWidth() {
        return this.scaled_width;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isStrikeout() {
        return this.strikeout;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void replay(WmfFile wmfFile) {
        MfLogFont mfLogFont = new MfLogFont();
        mfLogFont.setFace(this.getFontFace());
        mfLogFont.setSize(this.getScaledHeight());
        int n = 0;
        n = this.getWeight() > 650 ? 1 : 0;
        if (this.isItalic()) {
            n += 2;
        }
        mfLogFont.setStyle(n);
        mfLogFont.setUnderline(this.isUnderline());
        mfLogFont.setStrikeOut(this.isStrikeout());
        mfLogFont.setRotation(this.getEscapement() / 10);
        wmfFile.getCurrentState().setLogFont(mfLogFont);
        wmfFile.storeObject(mfLogFont);
    }

    protected void scaleXChanged() {
        this.scaled_width = this.getScaledX(this.width);
    }

    protected void scaleYChanged() {
        this.scaled_height = this.getScaledY(this.height);
    }

    public void setCharset(int n) {
        this.charset = n;
    }

    public void setClipPrecision(int n) {
        this.clipprecision = n;
    }

    public void setEscapement(int n) {
        this.escapement = n;
    }

    public void setFontFace(String string) {
        this.facename = string;
    }

    public void setHeight(int n) {
        this.height = n;
        this.scaleYChanged();
    }

    public void setItalic(boolean bl) {
        this.italic = bl;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public void setOutputPrecision(int n) {
        this.outprecision = n;
    }

    public void setPitchAndFamily(int n) {
        this.pitchAndFamily = n;
    }

    public void setQuality(int n) {
        this.quality = n;
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(POS_HEIGHT);
        if (n == 0) {
            n = 10;
        }
        if (n < 0) {
            n *= -1;
        }
        int n2 = mfRecord.getParam(POS_WIDTH);
        int n3 = mfRecord.getParam(POS_ESCAPEMENT);
        int n4 = mfRecord.getParam(POS_ORIENTATION);
        int n5 = mfRecord.getParam(POS_WEIGHT);
        int n6 = mfRecord.getParam(POS_FLAGS1) & 0xFF00;
        int n7 = mfRecord.getParam(POS_FLAGS1) & 0xFF;
        int n8 = mfRecord.getParam(POS_FLAGS2) & 0xFF00;
        int n9 = mfRecord.getParam(POS_FLAGS2) & 0xFF;
        int n10 = mfRecord.getParam(POS_PRECISION) & 0xFF00;
        int n11 = mfRecord.getParam(POS_PRECISION) & 0xFF;
        int n12 = mfRecord.getParam(POS_QUALITY) & 0xFF00;
        int n13 = mfRecord.getParam(POS_QUALITY) & 0xFF;
        String string = mfRecord.getStringParam(POS_FONTFACE, 32);
        this.setCharset(n9);
        this.setClipPrecision(n11);
        this.setEscapement(n3);
        this.setFontFace(string);
        this.setHeight(n);
        this.setItalic(n6 != 0);
        this.setOrientation(n4);
        this.setOutputPrecision(n10);
        this.setPitchAndFamily(n13);
        this.setQuality(n12);
        this.setStrikeout(n8 != 0);
        this.setUnderline(n7 != 0);
        this.setWeight(n5);
        this.setWidth(n2);
    }

    public void setStrikeout(boolean bl) {
        this.strikeout = bl;
    }

    public void setUnderline(boolean bl) {
        this.underline = bl;
    }

    public void setWeight(int n) {
        this.weight = n;
    }

    public void setWidth(int n) {
        this.width = n;
        this.scaleXChanged();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CREATE_FONT] face=");
        stringBuffer.append(this.getFontFace());
        stringBuffer.append(" height=");
        stringBuffer.append(this.getHeight());
        stringBuffer.append(" width=");
        stringBuffer.append(this.getWidth());
        stringBuffer.append(" weight=");
        stringBuffer.append(this.getWeight());
        stringBuffer.append(" italic=");
        stringBuffer.append(this.isItalic());
        stringBuffer.append(" Strikeout=");
        stringBuffer.append(this.isStrikeout());
        stringBuffer.append(" Underline=");
        stringBuffer.append(this.isUnderline());
        stringBuffer.append(" outprecision=");
        stringBuffer.append(this.getOutputPrecision());
        stringBuffer.append(" escapement=");
        stringBuffer.append(this.getEscapement());
        return stringBuffer.toString();
    }
}

