/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;

public class MfCmdEllipse
extends MfCmd {
    private static final int RECORD_SIZE = 4;
    private static final int POS_TOP = 2;
    private static final int POS_LEFT = 3;
    private static final int POS_RIGHT = 1;
    private static final int POS_BOTTOM = 0;
    private int x;
    private int y;
    private int width;
    private int height;
    private int scaled_x;
    private int scaled_y;
    private int scaled_width;
    private int scaled_height;

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public int getFunction() {
        return 1048;
    }

    public MfCmd getInstance() {
        return new MfCmdEllipse();
    }

    public MfRecord getRecord() {
        Rectangle rectangle = this.getBounds();
        MfRecord mfRecord = new MfRecord(4);
        mfRecord.setParam(0, (int)(rectangle.getY() + rectangle.getHeight()));
        mfRecord.setParam(1, (int)(rectangle.getX() + rectangle.getWidth()));
        mfRecord.setParam(2, (int)rectangle.getY());
        mfRecord.setParam(3, (int)rectangle.getX());
        return mfRecord;
    }

    public Rectangle getScaledBounds() {
        return new Rectangle(this.scaled_x, this.scaled_y, this.scaled_width, this.scaled_height);
    }

    public void replay(WmfFile wmfFile) {
        Graphics2D graphics2D = wmfFile.getGraphics2D();
        Rectangle rectangle = this.getScaledBounds();
        Ellipse2D.Double double_ = new Ellipse2D.Double();
        ((RectangularShape)double_).setFrame(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        MfDcState mfDcState = wmfFile.getCurrentState();
        if (mfDcState.getLogBrush().isVisible()) {
            mfDcState.preparePaint();
            graphics2D.fill(double_);
            mfDcState.postPaint();
        }
        if (mfDcState.getLogPen().isVisible()) {
            mfDcState.prepareDraw();
            graphics2D.draw(double_);
            mfDcState.postDraw();
        }
    }

    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
        this.scaled_width = this.getScaledX(this.width);
    }

    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
        this.scaled_height = this.getScaledY(this.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        int n2 = mfRecord.getParam(1);
        int n3 = mfRecord.getParam(2);
        int n4 = mfRecord.getParam(3);
        this.setBounds(n4, n3, n2 - n4, n - n3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ELLIPSE] bounds=");
        stringBuffer.append(this.getBounds());
        return stringBuffer.toString();
    }
}

