/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Color;
import java.awt.Point;
import org.jfree.pixie.wmf.GDIColor;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;

public class MfCmdFloodFill
extends MfCmd {
    private static final int RECORD_SIZE = 4;
    private static final int POS_COLOR = 0;
    private static final int POS_Y = 2;
    private static final int POS_X = 3;
    private int x;
    private int y;
    private int scaled_x;
    private int scaled_y;
    private Color color;

    public Color getColor() {
        return this.color;
    }

    public int getFunction() {
        return 1049;
    }

    public MfCmd getInstance() {
        return new MfCmdFloodFill();
    }

    public MfRecord getRecord() {
        MfRecord mfRecord = new MfRecord(4);
        mfRecord.setLongParam(0, GDIColor.translateColor(this.getColor()));
        Point point = this.getTarget();
        mfRecord.setParam(2, (int)point.getY());
        mfRecord.setParam(3, (int)point.getX());
        return mfRecord;
    }

    public Point getScaledTarget() {
        return new Point(this.scaled_x, this.scaled_y);
    }

    public Point getTarget() {
        return new Point(this.x, this.y);
    }

    public void replay(WmfFile wmfFile) {
    }

    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
    }

    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getLongParam(0);
        GDIColor gDIColor = new GDIColor(n);
        int n2 = mfRecord.getParam(2);
        int n3 = mfRecord.getParam(3);
        this.setTarget(n3, n2);
        this.setColor(gDIColor);
    }

    public void setTarget(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setTarget(Point point) {
        this.setTarget(point.x, point.y);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FLOOD_FILL] color=");
        stringBuffer.append(this.getColor());
        stringBuffer.append(" target=");
        stringBuffer.append(this.getTarget());
        return stringBuffer.toString();
    }
}

