/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Color;
import java.awt.Graphics2D;
import org.jfree.pixie.wmf.MfLogRegion;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;

public class MfCmdInvertRegion
extends MfCmd {
    private int region;
    private static final int RECORD_SIZE = 1;
    private static final int POS_REGION = 0;

    public int getFunction() {
        return 298;
    }

    public MfCmd getInstance() {
        return new MfCmdInvertRegion();
    }

    public MfRecord getRecord() {
        MfRecord mfRecord = new MfRecord(1);
        mfRecord.setParam(0, this.getRegion());
        return mfRecord;
    }

    public int getRegion() {
        return this.region;
    }

    public void replay(WmfFile wmfFile) {
        Graphics2D graphics2D = (Graphics2D)wmfFile.getGraphics2D().create();
        graphics2D.setXORMode(Color.white);
        MfLogRegion mfLogRegion = wmfFile.getRegionObject(this.getRegion());
        graphics2D.fill(mfLogRegion.getBounds());
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }

    public void setRecord(MfRecord mfRecord) {
        this.region = mfRecord.getParam(0);
    }

    public void setRegion(int n) {
        this.region = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[INVERT_REGION] region=");
        stringBuffer.append(this.getRegion());
        return stringBuffer.toString();
    }
}

