/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Point;
import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;

public class MfCmdMoveTo
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_X = 1;
    private static final int POS_Y = 0;
    private int destX;
    private int destY;
    private int scaled_destX;
    private int scaled_destY;

    public Point getDestination() {
        return new Point(this.destX, this.destY);
    }

    public int getFunction() {
        return 532;
    }

    public MfCmd getInstance() {
        return new MfCmdMoveTo();
    }

    public MfRecord getRecord() {
        Point point = this.getDestination();
        MfRecord mfRecord = new MfRecord(2);
        mfRecord.setParam(0, point.y);
        mfRecord.setParam(1, point.x);
        return mfRecord;
    }

    public Point getScaledDestination() {
        return new Point(this.scaled_destX, this.scaled_destY);
    }

    public void replay(WmfFile wmfFile) {
        MfDcState mfDcState = wmfFile.getCurrentState();
        Point point = this.getScaledDestination();
        mfDcState.setCurPos(point.x, point.y);
    }

    protected void scaleXChanged() {
        this.scaled_destX = this.getScaledX(this.destX);
    }

    protected void scaleYChanged() {
        this.scaled_destY = this.getScaledY(this.destY);
    }

    public void setDestination(int n, int n2) {
        this.destX = n;
        this.destY = n2;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setDestination(Point point) {
        this.setDestination(point.x, point.y);
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        int n2 = mfRecord.getParam(1);
        this.setDestination(n2, n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[MOVE_TO] destination=");
        stringBuffer.append(this.getDestination());
        return stringBuffer.toString();
    }
}

