/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Point;
import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;

public class MfCmdOffsetViewportOrg
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_X = 1;
    private static final int POS_Y = 0;
    private int x;
    private int y;
    private int scaled_x;
    private int scaled_y;

    public Point getDestination() {
        return new Point(this.x, this.y);
    }

    public int getFunction() {
        return 529;
    }

    public MfCmd getInstance() {
        return new MfCmdOffsetViewportOrg();
    }

    public MfRecord getRecord() {
        Point point = this.getDestination();
        MfRecord mfRecord = new MfRecord(2);
        mfRecord.setParam(0, point.y);
        mfRecord.setParam(1, point.x);
        return mfRecord;
    }

    public Point getScaledDestination() {
        return new Point(this.scaled_x, this.scaled_y);
    }

    public void replay(WmfFile wmfFile) {
        MfDcState mfDcState = wmfFile.getCurrentState();
        Point point = this.getScaledDestination();
        mfDcState.setViewportOrg(mfDcState.getViewportOrgX() + point.x, mfDcState.getViewportOrgY() + point.y);
    }

    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
    }

    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
    }

    public void setDestination(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setDestination(Point point) {
        this.setDestination(point.x, point.y);
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        int n2 = mfRecord.getParam(1);
        this.setDestination(n2, n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[OFFSET_VIEWPORT] destination=");
        stringBuffer.append(this.getDestination());
        return stringBuffer.toString();
    }
}

