/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;

public class MfCmdPie
extends MfCmd {
    private static final int PARAM_X_END_POS = 0;
    private static final int PARAM_Y_END_POS = 1;
    private static final int PARAM_X_START_POS = 2;
    private static final int PARAM_Y_START_POS = 3;
    private static final int PARAM_BOTTOM_POS = 4;
    private static final int PARAM_RIGHT_POS = 5;
    private static final int PARAM_TOP_POS = 6;
    private static final int PARAM_LEFT_POS = 7;
    private static final int RECORD_SIZE = 8;
    private int x;
    private int y;
    private int width;
    private int height;
    private int xstart;
    private int ystart;
    private int xend;
    private int yend;
    private int scaled_x;
    private int scaled_y;
    private int scaled_width;
    private int scaled_height;
    private int scaled_xstart;
    private int scaled_ystart;
    private int scaled_xend;
    private int scaled_yend;

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Point getEndingIntersection() {
        return new Point(this.xend, this.yend);
    }

    public int getFunction() {
        return 2074;
    }

    public MfCmd getInstance() {
        return new MfCmdPie();
    }

    public MfRecord getRecord() {
        MfRecord mfRecord = new MfRecord(8);
        Rectangle rectangle = this.getBounds();
        Point point = this.getStartingIntersection();
        Point point2 = this.getEndingIntersection();
        mfRecord.setParam(7, (int)rectangle.getX());
        mfRecord.setParam(6, (int)rectangle.getY());
        mfRecord.setParam(5, (int)(rectangle.getX() + rectangle.getWidth()));
        mfRecord.setParam(4, (int)(rectangle.getY() + rectangle.getHeight()));
        mfRecord.setParam(3, (int)point.getY());
        mfRecord.setParam(2, (int)point.getX());
        mfRecord.setParam(1, (int)point2.getY());
        mfRecord.setParam(0, (int)point2.getX());
        return mfRecord;
    }

    public Rectangle getScaledBounds() {
        return new Rectangle(this.scaled_x, this.scaled_y, this.scaled_width, this.scaled_height);
    }

    public Point getScaledEndingIntersection() {
        return new Point(this.scaled_xend, this.scaled_yend);
    }

    public Point getScaledStartingIntersection() {
        return new Point(this.scaled_xstart, this.scaled_ystart);
    }

    public Point getStartingIntersection() {
        return new Point(this.xstart, this.ystart);
    }

    public void replay(WmfFile wmfFile) {
        Graphics2D graphics2D = wmfFile.getGraphics2D();
        Rectangle rectangle = this.getScaledBounds();
        Point point = this.getScaledStartingIntersection();
        Point point2 = this.getScaledEndingIntersection();
        Arc2D.Double double_ = new Arc2D.Double();
        double_.setArcType(2);
        double_.setFrame(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        double_.setAngles(point.x, point.y, point2.x, point2.y);
        MfDcState mfDcState = wmfFile.getCurrentState();
        if (mfDcState.getLogBrush().isVisible()) {
            mfDcState.preparePaint();
            graphics2D.fill(double_);
            mfDcState.postPaint();
        }
        if (mfDcState.getLogPen().isVisible()) {
            mfDcState.prepareDraw();
            graphics2D.draw(double_);
            mfDcState.postDraw();
        }
    }

    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
        this.scaled_width = this.getScaledX(this.width);
        this.scaled_xstart = this.getScaledX(this.xstart);
        this.scaled_xend = this.getScaledX(this.xend);
    }

    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
        this.scaled_height = this.getScaledY(this.height);
        this.scaled_ystart = this.getScaledY(this.xstart);
        this.scaled_yend = this.getScaledY(this.xend);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setEndingIntersection(int n, int n2) {
        this.xend = n;
        this.yend = n2;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        int n2 = mfRecord.getParam(1);
        int n3 = mfRecord.getParam(2);
        int n4 = mfRecord.getParam(3);
        int n5 = mfRecord.getParam(4);
        int n6 = mfRecord.getParam(5);
        int n7 = mfRecord.getParam(6);
        int n8 = mfRecord.getParam(7);
        this.setBounds(n8, n7, n6 - n8, n5 - n7);
        this.setStartingIntersection(n3, n4);
        this.setEndingIntersection(n, n2);
    }

    public void setStartingIntersection(int n, int n2) {
        this.xstart = n;
        this.ystart = n2;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[PIE] bounds=");
        stringBuffer.append(this.getBounds());
        stringBuffer.append(" startIntersection=");
        stringBuffer.append(this.getStartingIntersection());
        stringBuffer.append(" endingIntersection=");
        stringBuffer.append(this.getEndingIntersection());
        return stringBuffer.toString();
    }
}

