/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdRestoreDc
extends MfCmd {
    private int dcId;

    public int getFunction() {
        return 295;
    }

    public MfCmd getInstance() {
        return new MfCmdRestoreDc();
    }

    public int getNSavedDC() {
        return this.dcId;
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord mfRecord = new MfRecord(1);
        mfRecord.setParam(0, this.getNSavedDC());
        return mfRecord;
    }

    public void replay(WmfFile wmfFile) {
        if (this.dcId == 0) {
            return;
        }
        if (this.dcId > 0) {
            wmfFile.restoreDCState(this.dcId);
        } else {
            wmfFile.restoreDCState(wmfFile.getStateCount() - this.dcId);
        }
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }

    public void setNSavedDC(int n) {
        this.dcId = n;
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        this.setNSavedDC(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[RESTORE_DC] nSavedDC=");
        stringBuffer.append(this.getNSavedDC());
        return stringBuffer.toString();
    }
}

