/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdRoundRect
extends MfCmd {
    private static final int RECORD_SIZE = 6;
    private static final int POS_TOP = 4;
    private static final int POS_LEFT = 5;
    private static final int POS_RIGHT = 3;
    private static final int POS_BOTTOM = 2;
    private static final int POS_ROUND_WIDTH = 1;
    private static final int POS_ROUND_HEIGHT = 0;
    private int x;
    private int y;
    private int width;
    private int height;
    private int roundWidth;
    private int roundHeight;
    private int scaled_x;
    private int scaled_y;
    private int scaled_width;
    private int scaled_height;
    private int scaled_roundWidth;
    private int scaled_roundHeight;

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public int getFunction() {
        return 1564;
    }

    public MfCmd getInstance() {
        return new MfCmdRoundRect();
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord mfRecord = new MfRecord(6);
        Dimension dimension = this.getRoundingDim();
        mfRecord.setParam(0, dimension.height);
        mfRecord.setParam(1, dimension.width);
        Rectangle rectangle = this.getBounds();
        mfRecord.setParam(2, rectangle.height + rectangle.y);
        mfRecord.setParam(3, rectangle.width + rectangle.x);
        mfRecord.setParam(4, rectangle.y);
        mfRecord.setParam(5, rectangle.x);
        return mfRecord;
    }

    public Dimension getRoundingDim() {
        return new Dimension(this.roundWidth, this.roundHeight);
    }

    public Rectangle getScaledBounds() {
        return new Rectangle(this.scaled_x, this.scaled_y, this.scaled_width, this.scaled_height);
    }

    public Dimension getScaledRoundingDim() {
        return new Dimension(this.scaled_roundWidth, this.scaled_roundHeight);
    }

    public void replay(WmfFile wmfFile) {
        Graphics2D graphics2D = wmfFile.getGraphics2D();
        Rectangle rectangle = this.getScaledBounds();
        Dimension dimension = this.getScaledRoundingDim();
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double();
        ((RoundRectangle2D)double_).setRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, dimension.width, dimension.height);
        MfDcState mfDcState = wmfFile.getCurrentState();
        if (mfDcState.getLogBrush().isVisible()) {
            mfDcState.preparePaint();
            graphics2D.fill(double_);
            mfDcState.postPaint();
        }
        if (mfDcState.getLogPen().isVisible()) {
            mfDcState.prepareDraw();
            graphics2D.draw(double_);
            mfDcState.postDraw();
        }
    }

    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
        this.scaled_width = this.getScaledX(this.width);
        this.scaled_roundWidth = this.getScaledX(this.roundWidth);
    }

    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
        this.scaled_height = this.getScaledY(this.height);
        this.scaled_roundHeight = this.getScaledY(this.roundHeight);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        int n2 = mfRecord.getParam(1);
        int n3 = mfRecord.getParam(2);
        int n4 = mfRecord.getParam(3);
        int n5 = mfRecord.getParam(4);
        int n6 = mfRecord.getParam(5);
        this.setBounds(n6, n5, n4 - n6, n3 - n5);
        this.setRoundingDim(n2, n);
    }

    public void setRoundingDim(int n, int n2) {
        this.roundWidth = n;
        this.roundHeight = n2;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ROUND_RECTANGLE] bounds=");
        stringBuffer.append(this.getBounds());
        stringBuffer.append(" roundingDim=");
        stringBuffer.append(this.getRoundingDim());
        return stringBuffer.toString();
    }
}

