/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdScaleViewportExt
extends MfCmd {
    private static final int RECORD_SIZE = 4;
    private static final int POS_Y_DENOM = 0;
    private static final int POS_X_DENOM = 2;
    private static final int POS_Y_NUM = 1;
    private static final int POS_X_NUM = 3;
    private int yNum;
    private int yDenom;
    private int xNum;
    private int xDenom;

    public int getFunction() {
        return 1042;
    }

    public MfCmd getInstance() {
        return new MfCmdScaleViewportExt();
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord mfRecord = new MfRecord(4);
        mfRecord.setParam(2, this.getXDenom());
        mfRecord.setParam(3, this.getXNum());
        mfRecord.setParam(0, this.getYDenom());
        mfRecord.setParam(1, this.getYNum());
        return mfRecord;
    }

    public int getXDenom() {
        return this.xDenom;
    }

    public int getXNum() {
        return this.xNum;
    }

    public double getXScale() {
        return (double)this.xNum / (double)this.xDenom;
    }

    public int getYDenom() {
        return this.yDenom;
    }

    public int getYNum() {
        return this.yNum;
    }

    public double getYScale() {
        return (double)this.yNum / (double)this.yDenom;
    }

    public void replay(WmfFile wmfFile) {
        wmfFile.getGraphics2D().scale((double)this.getXNum() / (double)this.getXDenom(), (double)this.getYNum() / (double)this.getYDenom());
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        int n2 = mfRecord.getParam(1);
        int n3 = mfRecord.getParam(2);
        int n4 = mfRecord.getParam(3);
        this.setXScale(n4, n3);
        this.setYScale(n2, n);
    }

    public void setXScale(int n, int n2) {
        this.xNum = n;
        this.xDenom = n2;
    }

    public void setYScale(int n, int n2) {
        this.yNum = n;
        this.yDenom = n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SCALE_VIEWPORT] scaleX=");
        stringBuffer.append(this.getXNum());
        stringBuffer.append("/");
        stringBuffer.append(this.getXDenom());
        stringBuffer.append(" scaley=");
        stringBuffer.append(this.getYNum());
        stringBuffer.append("/");
        stringBuffer.append(this.getYDenom());
        return stringBuffer.toString();
    }
}

