/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdSetPolyFillMode
extends MfCmd {
    private static final int RECORD_SIZE = 1;
    private static final int POS_POLYFILLMODE = 0;
    public static final int ALTERNATE = 1;
    public static final int WINDING = 2;
    private int fillmode;

    public int getFillMode() {
        return this.fillmode;
    }

    public int getFunction() {
        return 262;
    }

    public MfCmd getInstance() {
        return new MfCmdSetPolyFillMode();
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord mfRecord = new MfRecord(1);
        mfRecord.setParam(0, this.getFillMode());
        return mfRecord;
    }

    public void replay(WmfFile wmfFile) {
        MfDcState mfDcState = wmfFile.getCurrentState();
        mfDcState.setPolyFillMode(this.fillmode);
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }

    public void setFillMode(int n) {
        this.fillmode = n;
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        this.setFillMode(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SET_POLY_FILL_MODE] fillmode=");
        stringBuffer.append(this.getFillMode());
        return stringBuffer.toString();
    }
}

