/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdSetTextAlign
extends MfCmd {
    private static final int RECORD_SIZE = 1;
    private static final int POS_TEXT_ALIGNMENT = 0;
    private int textAlignMode;

    public int getFunction() {
        return 302;
    }

    public MfCmd getInstance() {
        return new MfCmdSetTextAlign();
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord mfRecord = new MfRecord(1);
        mfRecord.setParam(0, this.getTextAlignMode());
        return mfRecord;
    }

    public int getTextAlignMode() {
        return this.textAlignMode;
    }

    public void replay(WmfFile wmfFile) {
        MfDcState mfDcState = wmfFile.getCurrentState();
        mfDcState.setTextAlign(this.textAlignMode);
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        this.setTextAlignMode(n);
    }

    public void setTextAlignMode(int n) {
        this.textAlignMode = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SET_TEXT_ALIGN] textAlign=");
        stringBuffer.append(this.getTextAlignMode());
        return stringBuffer.toString();
    }
}

