/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Graphics2D;
import java.awt.Point;
import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdTextOut
extends MfCmd {
    private int x;
    private int y;
    private String text;
    private int count;
    private int scaled_x;
    private int scaled_y;

    public int getCount() {
        return this.count;
    }

    public Point getDestination() {
        return new Point(this.x, this.y);
    }

    public int getFunction() {
        return 1313;
    }

    public MfCmd getInstance() {
        return new MfCmdTextOut();
    }

    public MfRecord getRecord() throws RecordCreationException {
        String string = this.getText();
        int n = (int)Math.ceil(string.length() / 2);
        MfRecord mfRecord = new MfRecord(n + 3);
        mfRecord.setParam(0, string.length());
        byte[] byArray = string.getBytes();
        int n2 = 0;
        while (n2 < this.count) {
            mfRecord.setByte(MfRecord.RECORD_HEADER_SIZE + 2 + n2, byArray[n2]);
            ++n2;
        }
        Point point = this.getDestination();
        mfRecord.setParam((int)(Math.ceil(this.count / 2) + 1.0), point.y);
        mfRecord.setParam((int)(Math.ceil(this.count / 2) + 2.0), point.x);
        return mfRecord;
    }

    public Point getScaledDestination() {
        return new Point(this.scaled_x, this.scaled_y);
    }

    public String getText() {
        return this.text;
    }

    public void replay(WmfFile wmfFile) {
        Point point = this.getScaledDestination();
        int n = point.x;
        int n2 = point.y;
        Graphics2D graphics2D = wmfFile.getGraphics2D();
        MfDcState mfDcState = wmfFile.getCurrentState();
        mfDcState.prepareDrawText();
        graphics2D.drawString(this.text, n, n2);
        mfDcState.postDrawText();
    }

    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
    }

    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
    }

    public void setCount(int n) {
        this.count = n;
    }

    public void setDestination(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)mfRecord.getByte(MfRecord.RECORD_HEADER_SIZE + 2 + n2);
            ++n2;
        }
        String string = new String(byArray);
        int n3 = mfRecord.getParam((int)(Math.ceil(n / 2) + 1.0));
        int n4 = mfRecord.getParam((int)(Math.ceil(n / 2) + 2.0));
        this.setCount(n);
        this.setDestination(n4, n3);
        this.setText(string);
    }

    public void setText(String string) {
        this.text = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[TEXT_OUT] text=");
        stringBuffer.append(this.getText());
        stringBuffer.append(" destination=");
        stringBuffer.append(this.getDestination());
        stringBuffer.append(" count=");
        stringBuffer.append(this.getCount());
        return stringBuffer.toString();
    }
}

