/*
 * Decompiled with CFR 0.152.
 */
import cn.org.rapid_framework.page.SortInfo;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;

public class Ognl {
    public static boolean isEmpty(Object o) throws IllegalArgumentException {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            if (((String)o).length() == 0) {
                return true;
            }
        } else if (o instanceof Collection) {
            if (((Collection)o).isEmpty()) {
                return true;
            }
        } else if (o.getClass().isArray()) {
            if (Array.getLength(o) == 0) {
                return true;
            }
        } else if (o instanceof Map) {
            if (((Map)o).isEmpty()) {
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    public static boolean isNotEmpty(Object o) {
        return !Ognl.isEmpty(o);
    }

    public static boolean isNotBlank(Object o) {
        return !Ognl.isBlank(o);
    }

    public static boolean isNumber(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Number) {
            return true;
        }
        if (o instanceof String) {
            String str = (String)o;
            if (str.length() == 0) {
                return false;
            }
            if (str.trim().length() == 0) {
                return false;
            }
            return StringUtils.isNumeric((String)str);
        }
        return false;
    }

    public static boolean isBlank(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            String str = (String)o;
            return Ognl.isBlank(str);
        }
        return false;
    }

    public static boolean isBlank(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean checkOrderBy(String orderby, String validSortColumns) throws DataAccessException {
        if (Ognl.isBlank(orderby)) {
            return false;
        }
        if (orderby.indexOf("'") >= 0 || orderby.indexOf("\\") >= 0) {
            throw new IllegalArgumentException("orderBy:" + orderby + " has SQL Injection risk");
        }
        if (orderby != null && orderby.length() > 100) {
            throw new IllegalArgumentException("orderby.length() <= 100 must be true");
        }
        if (validSortColumns == null) {
            return true;
        }
        List<SortInfo> infos = SortInfo.parseSortColumns(orderby);
        String[] passColumns = validSortColumns.split(",");
        for (SortInfo info : infos) {
            String columnName;
            if (Ognl.isPass(passColumns, info, columnName = info.getColumnName())) continue;
            throw new InvalidDataAccessApiUsageException("orderby:[" + orderby + "] is invalid, only can orderby:" + validSortColumns);
        }
        return true;
    }

    private static boolean isPass(String[] passColumns, SortInfo info, String columnName) {
        for (String column : passColumns) {
            if (!column.equalsIgnoreCase(info.getColumnName())) continue;
            return true;
        }
        return false;
    }
}

