/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.extremecomponents;

import cn.org.rapid_framework.beanutils.BeanUtils;
import cn.org.rapid_framework.page.PageRequest;
import java.util.HashMap;
import java.util.Map;
import org.extremecomponents.table.limit.Filter;
import org.extremecomponents.table.limit.Limit;
import org.extremecomponents.table.limit.Sort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtremeTablePageRequestFactory {
    public static PageRequest<Map> createFromLimit(Limit limit, String defaultSortColumns) {
        PageRequest result = new PageRequest();
        return ExtremeTablePageRequestFactory.bindPageRequest(result, limit, defaultSortColumns);
    }

    public static PageRequest createFromLimit(Limit limit) {
        return ExtremeTablePageRequestFactory.createFromLimit(limit, null);
    }

    public static PageRequest<Map> bindPageRequest(PageRequest pageRequest, Limit limit, String defaultSortColumns) {
        Map filters = ExtremeTablePageRequestFactory.getFilters(limit);
        pageRequest.setFilters(filters);
        BeanUtils.copyProperties(pageRequest, (Object)filters);
        pageRequest.setPageNumber(limit.getPage());
        pageRequest.setPageSize(limit.getCurrentRowsDisplayed());
        pageRequest.setSortColumns(ExtremeTablePageRequestFactory.getSortingColumns(limit, defaultSortColumns));
        return pageRequest;
    }

    private static Map getFilters(Limit limit) {
        Filter[] filters = limit.getFilterSet().getFilters();
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < filters.length; ++i) {
            Filter filter = filters[i];
            result.put(filter.getAlias(), filter.getValue());
        }
        return result;
    }

    private static String getSortingColumns(Limit limit, String defaultSortColumns) {
        Sort sort = limit.getSort();
        if (sort.getProperty() == null) {
            return defaultSortColumns;
        }
        String sortOrder = sort.getSortOrder() == null ? "" : " " + sort.getSortOrder();
        String column = sort.isAliased() ? sort.getAlias() : sort.getProperty();
        String sortColumns = column + sortOrder;
        return sortColumns;
    }
}

