/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.jdbc.sqlgenerator.metadata;

import cn.org.rapid_framework.jdbc.sqlgenerator.metadata.Column;
import cn.org.rapid_framework.jdbc.sqlgenerator.metadata.Table;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.persistence.Id;
import javax.persistence.Transient;

public class MetadataCreateUtils {
    private static boolean isJPAClassAvaiable = false;

    public static Table createTable(Class clazz) {
        BeanInfo info = MetadataCreateUtils.getBeanInfo(clazz);
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        ArrayList<Column> columns = new ArrayList<Column>();
        for (PropertyDescriptor pd : pds) {
            Method readMethod;
            if ("class".equals(pd.getName()) || (readMethod = pd.getReadMethod()) == null || pd.getWriteMethod() == null || MetadataCreateUtils.isTransientProperty(readMethod, pd.getWriteMethod()) || !MetadataCreateUtils.isNativeJavaType(readMethod.getReturnType())) continue;
            boolean isPrimaryKey = MetadataCreateUtils.isPrimaryKeyColumn(readMethod);
            String sqlName = MetadataCreateUtils.getColumnSqlName(pd, readMethod);
            Column column = new Column(sqlName, pd.getName(), isPrimaryKey);
            column.setInsertable(MetadataCreateUtils.getColumnInsertable(pd, readMethod));
            column.setUpdatable(MetadataCreateUtils.getColumnUpdatable(pd, readMethod));
            column.setUnique(MetadataCreateUtils.getColumnUnique(pd, readMethod));
            columns.add(column);
        }
        Table t = new Table(MetadataCreateUtils.getTableName(clazz), columns);
        return t;
    }

    static boolean isNativeJavaType(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isArray()) {
            return false;
        }
        return clazz.isPrimitive() || clazz.getName().startsWith("java.") || clazz.getName().startsWith("javax.");
    }

    private static boolean isTransientProperty(Method readMethod, Method writeMethod) {
        return isJPAClassAvaiable && readMethod.isAnnotationPresent(Transient.class);
    }

    private static BeanInfo getBeanInfo(Class clazz) {
        try {
            return Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException("error: generate Table instance from Class,clazz:" + clazz, e);
        }
    }

    private static boolean isPrimaryKeyColumn(Method readMethod) {
        boolean isPrimaryKey = false;
        if (isJPAClassAvaiable && readMethod.isAnnotationPresent(Id.class)) {
            isPrimaryKey = true;
        }
        return isPrimaryKey;
    }

    private static String getColumnSqlName(PropertyDescriptor pd, Method readMethod) {
        javax.persistence.Column annColumn;
        String sqlName = null;
        if (isJPAClassAvaiable && (annColumn = readMethod.getAnnotation(javax.persistence.Column.class)) != null) {
            sqlName = annColumn.name();
        }
        if (sqlName == null || sqlName.length() == 0) {
            sqlName = MetadataCreateUtils.toUnderscoreName(pd.getName());
        }
        return sqlName;
    }

    private static boolean getColumnInsertable(PropertyDescriptor pd, Method method) {
        javax.persistence.Column annColumn;
        boolean insertable = true;
        if (isJPAClassAvaiable && (annColumn = method.getAnnotation(javax.persistence.Column.class)) != null) {
            insertable = annColumn.insertable();
        }
        return insertable;
    }

    private static boolean getColumnUpdatable(PropertyDescriptor pd, Method method) {
        javax.persistence.Column annColumn;
        boolean updatable = true;
        if (isJPAClassAvaiable && (annColumn = method.getAnnotation(javax.persistence.Column.class)) != null) {
            updatable = annColumn.updatable();
        }
        return updatable;
    }

    private static boolean getColumnUnique(PropertyDescriptor pd, Method method) {
        javax.persistence.Column annColumn;
        boolean unique = false;
        if (isJPAClassAvaiable && (annColumn = method.getAnnotation(javax.persistence.Column.class)) != null) {
            unique = annColumn.unique();
        }
        return unique;
    }

    private static String getTableName(Class clazz) {
        javax.persistence.Table annTable;
        String tableName = MetadataCreateUtils.toUnderscoreName(clazz.getSimpleName());
        if (isJPAClassAvaiable && (annTable = clazz.getAnnotation(javax.persistence.Table.class)) != null) {
            tableName = annTable.name();
        }
        return tableName;
    }

    private static String toUnderscoreName(String name) {
        if (name == null) {
            return null;
        }
        String filteredName = name;
        if (filteredName.indexOf("_") >= 0 && filteredName.equals(filteredName.toUpperCase())) {
            filteredName = filteredName.toLowerCase();
        }
        if (filteredName.indexOf("_") == -1 && filteredName.equals(filteredName.toUpperCase())) {
            filteredName = filteredName.toLowerCase();
        }
        StringBuffer result = new StringBuffer();
        if (filteredName != null && filteredName.length() > 0) {
            result.append(filteredName.substring(0, 1).toLowerCase());
            for (int i = 1; i < filteredName.length(); ++i) {
                String preChart = filteredName.substring(i - 1, i);
                String c = filteredName.substring(i, i + 1);
                if (c.equals("_")) {
                    result.append("_");
                    continue;
                }
                if (preChart.equals("_")) {
                    result.append(c.toLowerCase());
                    continue;
                }
                if (c.matches("\\d")) {
                    result.append(c);
                    continue;
                }
                if (c.equals(c.toUpperCase())) {
                    result.append("_");
                    result.append(c.toLowerCase());
                    continue;
                }
                result.append(c);
            }
        }
        return result.toString();
    }

    static {
        try {
            Class.forName("javax.persistence.Table");
            isJPAClassAvaiable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

