/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.lang.enums;

import cn.org.rapid_framework.lang.enums.EnumBase;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumBaseUtils {
    public static <T extends EnumBase> LinkedHashMap toMap(Class<? extends EnumBase> enumClass) {
        return EnumBaseUtils.toMap((EnumBase[])enumClass.getEnumConstants());
    }

    public static <T extends EnumBase> LinkedHashMap toMap(T[] values) {
        LinkedHashMap map = new LinkedHashMap();
        for (T item : values) {
            map.put(item.getCode(), item.getDesc());
        }
        return map;
    }

    public static <T extends EnumBase<K>, K> K getCode(T enumValue) {
        if (enumValue == null) {
            return null;
        }
        return enumValue.getCode();
    }

    public static <T extends EnumBase> String getDesc(T enumValue) {
        if (enumValue == null) {
            return null;
        }
        return enumValue.getDesc();
    }

    public static <T extends Enum> String getName(T enumValue) {
        if (enumValue == null) {
            return null;
        }
        return enumValue.name();
    }

    public static <T extends EnumBase> T getByCode(Object code, Class<? extends EnumBase> enumClass) {
        return (T)EnumBaseUtils.getByCode((Object)code, (EnumBase[])enumClass.getEnumConstants());
    }

    public static <T extends EnumBase> T getByCode(Object code, T[] values) {
        if (code == null) {
            return null;
        }
        if (code instanceof String && StringUtils.isBlank((String)((String)code))) {
            return null;
        }
        for (T item : values) {
            if (!item.getCode().equals(code)) continue;
            return item;
        }
        return null;
    }

    public static <T extends EnumBase> T getRequiredByCode(Object code, Class<? extends EnumBase> enumClass) {
        return (T)EnumBaseUtils.getRequiredByCode((Object)code, (EnumBase[])enumClass.getEnumConstants());
    }

    public static <T extends EnumBase> T getRequiredByCode(Object code, T[] values) throws IllegalArgumentException {
        if (code == null) {
            return null;
        }
        if (code instanceof String && StringUtils.isBlank((String)((String)code))) {
            return null;
        }
        EnumBase v = EnumBaseUtils.getByCode((Object)code, values);
        if (v == null) {
            if (values.length > 0) {
                String className = values[0].getClass().getName();
                throw new IllegalArgumentException("not found Enum:" + className + " value by code:" + code);
            }
            throw new IllegalArgumentException("not found Enum by code:" + code);
        }
        return (T)v;
    }
}

