/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.mock;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class MockOpenSessionInViewFilter {
    protected static Log logger = LogFactory.getLog(MockOpenSessionInViewFilter.class);
    private boolean singleSession = true;
    private FlushMode flushMode = FlushMode.NEVER;
    private SessionFactory sessionFactory;
    boolean participate = false;

    public MockOpenSessionInViewFilter() {
    }

    public MockOpenSessionInViewFilter(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setSingleSession(boolean singleSession) {
        this.singleSession = singleSession;
    }

    protected boolean isSingleSession() {
        return this.singleSession;
    }

    public void setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    protected FlushMode getFlushMode() {
        return this.flushMode;
    }

    public void endFilter() {
        if (!this.participate) {
            if (this.isSingleSession()) {
                SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                logger.debug((Object)"Closing single Hibernate Session in OpenSessionInViewFilter");
                this.closeSession(sessionHolder.getSession(), this.sessionFactory);
            } else {
                SessionFactoryUtils.processDeferredClose((SessionFactory)this.sessionFactory);
            }
        }
    }

    public SessionFactory beginFilter() {
        SessionFactory sessionFactory = this.lookupSessionFactory();
        this.participate = false;
        if (this.isSingleSession()) {
            if (TransactionSynchronizationManager.hasResource((Object)sessionFactory)) {
                this.participate = true;
            } else {
                logger.debug((Object)"Opening single Hibernate Session in OpenSessionInViewFilter");
                Session session = this.getSession(sessionFactory);
                TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)new SessionHolder(session));
            }
        } else if (SessionFactoryUtils.isDeferredCloseActive((SessionFactory)sessionFactory)) {
            this.participate = true;
        } else {
            SessionFactoryUtils.initDeferredClose((SessionFactory)sessionFactory);
        }
        return sessionFactory;
    }

    protected SessionFactory lookupSessionFactory() {
        if (this.sessionFactory == null) {
            throw new IllegalStateException("'sessionFactory' property must be not null");
        }
        return this.sessionFactory;
    }

    protected Session getSession(SessionFactory sessionFactory) throws DataAccessResourceFailureException {
        Session session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
        FlushMode flushMode = this.getFlushMode();
        if (flushMode != null) {
            session.setFlushMode(flushMode);
        }
        return session;
    }

    protected void closeSession(Session session, SessionFactory sessionFactory) {
        SessionFactoryUtils.closeSession((Session)session);
    }
}

