/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.spring.util;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.PriorityOrdered;

public class SystemPropertyInitializingBean
implements InitializingBean,
PriorityOrdered {
    private Properties systemProperties;
    private int order = Integer.MIN_VALUE;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public void afterPropertiesSet() throws Exception {
        System.setProperty("hostname", this.getHostName());
        if (this.systemProperties != null) {
            System.getProperties().putAll((Map<?, ?>)this.systemProperties);
        }
    }

    public String getHostName() {
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            return localMachine.getHostName();
        }
        catch (UnknownHostException e) {
            return "unknown_hostname";
        }
    }

    public static void log4jConfigureAndWatch(File file, long refreshInterval) {
        if (file.getAbsolutePath().toLowerCase().endsWith(".xml")) {
            DOMConfigurator.configureAndWatch((String)file.getAbsolutePath(), (long)refreshInterval);
        } else {
            PropertyConfigurator.configureAndWatch((String)file.getAbsolutePath(), (long)refreshInterval);
        }
    }
}

