/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.struts2.dispatcher;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.StrutsResultSupport;

public class DirectResult
extends StrutsResultSupport {
    private static final Log _log = LogFactory.getLog(DirectResult.class);
    private static final long serialVersionUID = 3633371605905583950L;
    private boolean prependServletContext = true;
    private static final String FORWARD_PREFIX = "forward:";
    private static final String REDIRECT_PREFIX = "redirect:";

    public DirectResult() {
    }

    public DirectResult(String location) {
        super(location);
    }

    public void setPrependServletContext(boolean prependServletContext) {
        this.prependServletContext = prependServletContext;
    }

    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        HttpServletResponse response = (HttpServletResponse)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        HttpServletRequest request = (HttpServletRequest)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        String resultCodeAsLocation = invocation.getResultCode();
        if (resultCodeAsLocation == null) {
            return;
        }
        if ((resultCodeAsLocation = TextParseUtil.translateVariables((String)resultCodeAsLocation, (ValueStack)invocation.getStack())).startsWith("!")) {
            this.doRedirect(invocation, request, response, resultCodeAsLocation.substring(1));
            return;
        }
        if (resultCodeAsLocation.startsWith(REDIRECT_PREFIX)) {
            this.doRedirect(invocation, request, response, resultCodeAsLocation.substring(REDIRECT_PREFIX.length()));
            return;
        }
        if (resultCodeAsLocation.startsWith(FORWARD_PREFIX)) {
            this.doDispatcher(response, request, resultCodeAsLocation.substring(FORWARD_PREFIX.length()));
            return;
        }
        this.doDispatcher(response, request, resultCodeAsLocation);
    }

    private void doDispatcher(HttpServletResponse response, HttpServletRequest request, String resultCodeAsLocation) throws IOException, ServletException {
        PageContext pageContext;
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Forwarding to location:" + resultCodeAsLocation));
        }
        if ((pageContext = ServletActionContext.getPageContext()) != null) {
            pageContext.include(resultCodeAsLocation);
            return;
        }
        RequestDispatcher dispatcher = request.getRequestDispatcher(resultCodeAsLocation);
        if (dispatcher == null) {
            response.sendError(404, "result '" + resultCodeAsLocation + "' not found");
            return;
        }
        if (!response.isCommitted() && request.getAttribute("javax.servlet.include.servlet_path") == null) {
            request.setAttribute("struts.view_uri", (Object)resultCodeAsLocation);
            request.setAttribute("struts.request_uri", (Object)request.getRequestURI());
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void doRedirect(ActionInvocation invocation, HttpServletRequest request, HttpServletResponse response, String redirectLocation) throws IOException {
        if (DirectResult.isPathUrl(redirectLocation)) {
            if (!redirectLocation.startsWith("/")) {
                String namespace = invocation.getProxy().getNamespace();
                redirectLocation = namespace != null && namespace.length() > 0 && !"/".equals(namespace) ? namespace + "/" + redirectLocation : "/" + redirectLocation;
            }
            if (this.prependServletContext && request.getContextPath() != null && request.getContextPath().length() > 0) {
                redirectLocation = request.getContextPath() + redirectLocation;
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Redirect to location:" + redirectLocation));
        }
        response.sendRedirect(response.encodeRedirectURL(redirectLocation));
    }

    private static boolean isPathUrl(String url) {
        return url.indexOf(58) == -1;
    }
}

