/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.test.dbunit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.sql.DataSource;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.QueryDataSet;
import org.dbunit.dataset.CachedDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.springframework.util.ResourceUtils;

public class DBUnitFlatXmlHelper {
    private DatabaseConnection databaseConnection;
    private CachedDataSet cachedDataSet;
    private DataSource dataSource;
    private List testDataSets = new ArrayList();
    private String jdbcSchema = null;

    public DBUnitFlatXmlHelper() {
    }

    public DBUnitFlatXmlHelper(DataSource d) throws Exception {
        this(d, null);
    }

    public DBUnitFlatXmlHelper(DataSource dataSource, String jdbcSchema) throws Exception {
        this.jdbcSchema = jdbcSchema;
        this.setDataSource(dataSource);
    }

    public void setJdbcSchema(String jdbcSchema) {
        this.jdbcSchema = jdbcSchema;
    }

    public void insertTestDatas(String ... flatXmlDataFiles) throws DatabaseUnitException, SQLException, IOException {
        if (flatXmlDataFiles == null) {
            return;
        }
        for (String dataFile : flatXmlDataFiles) {
            try {
                File file = ResourceUtils.getFile((String)dataFile);
                System.out.println("[DbUnit INFO] insert test dataFile,filepath=" + dataFile);
                this.insertTestData(file);
            }
            catch (FileNotFoundException e) {
                System.out.println("[DbUnit WARN] not found DbUnit DataFile,filepath=" + dataFile);
            }
        }
    }

    public void insertTestData(File flatXMLFile) throws FileNotFoundException, IOException, DatabaseUnitException, SQLException {
        try {
            FlatXmlDataSet testDataSet = new FlatXmlDataSet((InputStream)new FileInputStream(flatXMLFile));
            DatabaseOperation.REFRESH.execute((IDatabaseConnection)this.getDatabaseConnection(), (IDataSet)testDataSet);
            this.testDataSets.add(testDataSet);
        }
        catch (AmbiguousTableNameException e) {
            throw new DatabaseUnitException("\u51fa\u73b0AmbiguousTableNameException\u5f02\u5e38\uff0c\u4f7f\u7528\u547d\u4ee4:purge recyclebin\u6e05\u7a7a\u4e00\u4e0boracle\u56de\u6536\u7ad9,\u5e76\u4e3adbunit\u6307\u5b9ajdbcSchema", (Throwable)e);
        }
    }

    public void deleteTestDatas() throws DatabaseUnitException, SQLException {
        System.out.println("[DbUnit INFO] delete test datas");
        ListIterator it = this.testDataSets.listIterator();
        while (it.hasNext()) {
            IDataSet testDataSet = (IDataSet)it.next();
            DatabaseOperation.DELETE.execute((IDatabaseConnection)this.getDatabaseConnection(), testDataSet);
            it.remove();
        }
        this.testDataSets.clear();
    }

    public void backupTable(String tableName) throws Exception {
        String[] tableNames = new String[]{tableName};
        this.backupTables(tableNames);
    }

    public void backupTables(String[] tableNames) throws Exception {
        this.cachedDataSet = new CachedDataSet(this.getDatabaseConnection().createDataSet(tableNames));
    }

    public void restoreTables() throws Exception {
        this.deleteTestDatas();
        if (this.cachedDataSet != null) {
            DatabaseOperation.CLEAN_INSERT.execute((IDatabaseConnection)this.getDatabaseConnection(), (IDataSet)this.cachedDataSet);
            this.cachedDataSet = null;
        }
    }

    public void exportFromDBToFile(String[] tableName, String[] sqlQuery, File flatXMLFile) throws DataSetException, FileNotFoundException, SQLException, IOException {
        if (tableName.length != sqlQuery.length) {
            throw new RuntimeException("tableName.length=" + tableName.length + " != query.length=" + sqlQuery.length);
        }
        for (int i = 0; i < tableName.length; ++i) {
            this.exportFromDBToFile(tableName, sqlQuery, flatXMLFile);
        }
    }

    public void exportFromDBToFile(String tableName, String sqlQuery, File flatXMLFile) throws DataSetException, FileNotFoundException, SQLException, IOException {
        QueryDataSet partialDataSet = new QueryDataSet((IDatabaseConnection)this.getDatabaseConnection());
        partialDataSet.addTable(tableName, sqlQuery);
        FlatXmlDataSet.write((IDataSet)partialDataSet, (OutputStream)new FileOutputStream(flatXMLFile));
    }

    public void exportFromDBToFile(String tableName, File flatXMLFile) throws DataSetException, FileNotFoundException, SQLException, IOException {
        this.exportFromDBToFile(new String[]{tableName}, flatXMLFile);
    }

    public void exportFromDBToFile(String[] tableNames, File flatXMLFile) throws SQLException, DataSetException, FileNotFoundException, IOException {
        QueryDataSet partialDataSet = new QueryDataSet((IDatabaseConnection)this.getDatabaseConnection());
        for (int i = 0; i < tableNames.length; ++i) {
            partialDataSet.addTable(tableNames[i]);
        }
        FlatXmlDataSet.write((IDataSet)partialDataSet, (OutputStream)new FileOutputStream(flatXMLFile));
    }

    public void setDataSource(DataSource d) throws Exception {
        this.dataSource = d;
        this.initDbUnitConnection();
    }

    public void setDataSource(DataSource d, String jdbcSchema) throws Exception {
        this.setJdbcSchema(jdbcSchema);
        this.setDataSource(d);
    }

    public void setDatabaseConnection(DatabaseConnection databaseConnection) {
        this.databaseConnection = databaseConnection;
    }

    public void close() throws SQLException {
        if (this.databaseConnection != null) {
            this.databaseConnection.close();
        }
    }

    private void initDbUnitConnection() throws Exception {
        if (this.dataSource != null) {
            this.databaseConnection = new DatabaseConnection(this.dataSource.getConnection(), this.jdbcSchema);
        }
    }

    private DatabaseConnection getDatabaseConnection() {
        if (this.databaseConnection == null) {
            throw new RuntimeException("\u8bf7\u5148\u8bbe\u7f6e\u6570\u636e\u6e90,\u6267\u884csetDataSource()");
        }
        return this.databaseConnection;
    }
}

