/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.util;

import java.util.Collection;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Asserter {
    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isTrue(boolean expression) {
        Asserter.isTrue(expression, "[Assertion failed] - this expression must be true");
    }

    public static void isTrue(boolean expression, RuntimeException throwIfAssertFail) {
        if (!expression) {
            throw throwIfAssertFail;
        }
    }

    public static void isNull(Object object, String message) {
        if (object != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isNull(Object object) {
        Asserter.isNull(object, "[Assertion failed] - the object argument must be null");
    }

    public static void isNull(Object object, RuntimeException throwIfAssertFail) {
        if (object != null) {
            throw throwIfAssertFail;
        }
    }

    public static <T> T notNull(T object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
        return object;
    }

    public static <T> T notNull(T object) {
        return Asserter.notNull(object, "[Assertion failed] - this argument is required; it must not be null");
    }

    public static <T> T notNull(T object, RuntimeException throwIfAssertFail) {
        if (object == null) {
            throw throwIfAssertFail;
        }
        return object;
    }

    public static String hasLength(String text, String message) {
        if (!StringUtils.hasLength((String)text)) {
            throw new IllegalArgumentException(message);
        }
        return text;
    }

    public static String hasLength(String text) {
        return Asserter.hasLength(text, "[Assertion failed] - this String argument must have length; it must not be null or empty");
    }

    public static String hasLength(String text, RuntimeException throwIfAssertFail) {
        if (!StringUtils.hasLength((String)text)) {
            throw throwIfAssertFail;
        }
        return text;
    }

    public static String hasText(String text, String message) {
        if (!StringUtils.hasText((String)text)) {
            throw new IllegalArgumentException(message);
        }
        return text;
    }

    public static String hasText(String text) {
        return Asserter.hasText(text, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
    }

    public static String hasText(String text, RuntimeException throwIfAssertFail) {
        if (!StringUtils.hasText((String)text)) {
            throw throwIfAssertFail;
        }
        return text;
    }

    public static String doesNotContain(String textToSearch, String substring, String message) {
        if (StringUtils.hasLength((String)textToSearch) && StringUtils.hasLength((String)substring) && textToSearch.indexOf(substring) != -1) {
            throw new IllegalArgumentException(message);
        }
        return textToSearch;
    }

    public static String doesNotContain(String textToSearch, String substring) {
        return Asserter.doesNotContain(textToSearch, substring, "[Assertion failed] - this String argument must not contain the substring [" + substring + "]");
    }

    public static String doesNotContain(String textToSearch, String substring, RuntimeException throwIfAssertFail) {
        if (StringUtils.hasLength((String)textToSearch) && StringUtils.hasLength((String)substring) && textToSearch.indexOf(substring) != -1) {
            throw throwIfAssertFail;
        }
        return textToSearch;
    }

    public static Object[] notEmpty(Object[] array, String message) {
        if (ObjectUtils.isEmpty((Object[])array)) {
            throw new IllegalArgumentException(message);
        }
        return array;
    }

    public static Object[] notEmpty(Object[] array) {
        return Asserter.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element");
    }

    public static Object[] notEmpty(Object[] array, RuntimeException throwIfAssertFail) {
        if (ObjectUtils.isEmpty((Object[])array)) {
            throw throwIfAssertFail;
        }
        return array;
    }

    public static Object[] noNullElements(Object[] array, String message) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                throw new IllegalArgumentException(message);
            }
        }
        return array;
    }

    public static Object[] noNullElements(Object[] array) {
        return Asserter.noNullElements(array, "[Assertion failed] - this array must not contain any null elements");
    }

    public static Object[] noNullElements(Object[] array, RuntimeException throwIfAssertFail) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                throw throwIfAssertFail;
            }
        }
        return array;
    }

    public static Collection notEmpty(Collection collection, String message) {
        if (CollectionUtils.isEmpty((Collection)collection)) {
            throw new IllegalArgumentException(message);
        }
        return collection;
    }

    public static Collection notEmpty(Collection collection) {
        return Asserter.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element");
    }

    public static Collection notEmpty(Collection collection, RuntimeException throwIfAssertFail) {
        if (CollectionUtils.isEmpty((Collection)collection)) {
            throw throwIfAssertFail;
        }
        return collection;
    }

    public static Map notEmpty(Map map, String message) {
        if (CollectionUtils.isEmpty((Map)map)) {
            throw new IllegalArgumentException(message);
        }
        return map;
    }

    public static Map notEmpty(Map map) {
        return Asserter.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry");
    }

    public static Map notEmpty(Map map, RuntimeException throwIfAssertFail) {
        if (CollectionUtils.isEmpty((Map)map)) {
            throw throwIfAssertFail;
        }
        return map;
    }

    public static Object isInstanceOf(Class type, Object obj, String message) {
        Asserter.notNull(type, "Type to check against must not be null");
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException(message + "Object of class [" + (obj != null ? obj.getClass().getName() : "null") + "] must be an instance of " + type);
        }
        return obj;
    }

    public static Object isInstanceOf(Class clazz, Object obj) {
        return Asserter.isInstanceOf(clazz, obj, "");
    }

    public static Object isInstanceOf(Class type, Object obj, RuntimeException throwIfAssertFail) {
        Asserter.notNull(type, "Type to check against must not be null");
        if (!type.isInstance(obj)) {
            throw throwIfAssertFail;
        }
        return obj;
    }

    public static void isAssignable(Class superType, Class subType, String message) {
        Asserter.notNull(superType, "Type to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            throw new IllegalArgumentException(message + subType + " is not assignable to " + superType);
        }
    }

    public static void isAssignable(Class superType, Class subType) {
        Asserter.isAssignable(superType, subType, "");
    }

    public static void state(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void state(boolean expression) {
        Asserter.state(expression, "[Assertion failed] - this state invariant must be true");
    }
}

