/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateConvertUtils {
    public static Date parse(String dateString, String dateFormat) {
        return DateConvertUtils.parse(dateString, dateFormat, Date.class);
    }

    public static <T extends Date> T parse(String dateString, String dateFormat, Class<T> targetResultType) {
        if (StringUtils.isEmpty((String)dateString)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        try {
            long time = df.parse(dateString).getTime();
            Date t = (Date)targetResultType.getConstructor(Long.TYPE).newInstance(time);
            return (T)t;
        }
        catch (ParseException e) {
            String errorInfo = "cannot use dateformat:" + dateFormat + " parse datestring:" + dateString;
            throw new IllegalArgumentException(errorInfo, e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error targetResultType:" + targetResultType.getName(), e);
        }
    }

    public static String format(Date date, String dateFormat) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(dateFormat).format(date);
    }
}

