/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.util;

import cn.org.rapid_framework.util.HibernateBeanSerializerProxy;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.Hibernate;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateBeanSerializer<T> {
    T proxy = null;

    public HibernateBeanSerializer(T object, String ... excludesProperties) {
        if (object == null) {
            this.proxy = null;
        } else {
            ProxyFactory pf = new ProxyFactory();
            pf.setTargetClass(object.getClass());
            pf.setOptimize(true);
            pf.setTarget(object);
            pf.setProxyTargetClass(true);
            pf.setOpaque(true);
            pf.setExposeProxy(true);
            pf.setPreFiltered(true);
            pf.setInterfaces(new Class[]{HibernateBeanSerializerProxy.class});
            HibernateBeanSerializerAdvice beanSerializerAdvice = new HibernateBeanSerializerAdvice();
            beanSerializerAdvice.setExcludesProperties(excludesProperties);
            pf.addAdvice((Advice)beanSerializerAdvice);
            this.proxy = pf.getProxy();
        }
    }

    public T getProxy() {
        return this.proxy;
    }

    private static class HibernateBeanSerializerAdvice
    implements MethodInterceptor {
        private String[] excludesProperties = new String[0];

        private HibernateBeanSerializerAdvice() {
        }

        public String[] getExcludesProperties() {
            return this.excludesProperties;
        }

        public void setExcludesProperties(String[] excludesProperties) {
            this.excludesProperties = excludesProperties == null ? new String[]{} : excludesProperties;
        }

        public Object invoke(MethodInvocation mi) throws Throwable {
            String propertyName = HibernateBeanSerializerAdvice.getPropertyName(mi.getMethod().getName());
            Class<?> returnType = mi.getMethod().getReturnType();
            if (propertyName == null) {
                return mi.proceed();
            }
            if (!Hibernate.isPropertyInitialized((Object)mi.getThis(), (String)propertyName)) {
                return null;
            }
            if (this.isExclude(mi, propertyName)) {
                return null;
            }
            Object returnValue = mi.proceed();
            return this.processReturnValue(returnType, returnValue);
        }

        private Object processReturnValue(Class returnType, Object returnValue) {
            if (returnValue == null) {
                return null;
            }
            if (Modifier.isFinal(returnType.getModifiers())) {
                return returnValue;
            }
            if (!Hibernate.isInitialized((Object)returnValue)) {
                return null;
            }
            if (returnValue instanceof HibernateProxy) {
                return new HibernateBeanSerializer<Object>(returnValue, new String[0]).getProxy();
            }
            if (returnValue instanceof PersistentCollection) {
                if (returnType.isAssignableFrom(Map.class)) {
                    LinkedHashMap proxyMap = new LinkedHashMap();
                    Map map = (Map)returnValue;
                    Set entrySet = map.entrySet();
                    for (Map.Entry entry : entrySet) {
                        proxyMap.put(entry.getKey(), new HibernateBeanSerializer(entry.getValue(), new String[0]));
                    }
                    return proxyMap;
                }
                AbstractCollection proxyCollection = null;
                if (returnType.isAssignableFrom(Set.class)) {
                    proxyCollection = new LinkedHashSet();
                } else if (returnType.isAssignableFrom(List.class)) {
                    proxyCollection = new ArrayList();
                } else {
                    return returnValue;
                }
                for (Object o : (Collection)returnValue) {
                    proxyCollection.add(new HibernateBeanSerializer(o, new String[0]).getProxy());
                }
                return proxyCollection;
            }
            return returnValue;
        }

        private boolean isExclude(MethodInvocation mi, String propertyName) throws Throwable {
            for (String excludePropertyName : this.excludesProperties) {
                if (!propertyName.equals(excludePropertyName)) continue;
                return true;
            }
            return false;
        }

        private static String getPropertyName(String methodName) {
            String propertyName = null;
            if (methodName.startsWith("get")) {
                propertyName = methodName.substring("get".length());
            } else if (methodName.startsWith("is")) {
                propertyName = methodName.substring("is".length());
            } else if (methodName.startsWith("set")) {
                propertyName = methodName.substring("set".length());
            }
            return propertyName == null ? null : StringUtils.uncapitalize((String)propertyName);
        }
    }
}

