/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoopRunnable
implements Runnable {
    Log log = LogFactory.getLog(LoopRunnable.class);
    Runnable delegate;
    private boolean running = false;
    private boolean paused = false;
    private long sleepInterval = 0L;

    public LoopRunnable(Runnable delegate) {
        this.delegate = delegate;
    }

    public void shutdown() {
        this.running = false;
    }

    public void pause() {
        this.paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.paused = false;
        LoopRunnable loopRunnable = this;
        synchronized (loopRunnable) {
            this.notify();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public long getSleepInterval() {
        return this.sleepInterval;
    }

    public void setSleepInterval(long sleepTimeMillis) {
        this.sleepInterval = sleepTimeMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        try {
            this.beforeStart();
            while (this.running) {
                this.pausedIfRequired();
                try {
                    this.delegate.run();
                }
                catch (Exception e) {
                    this.handleIterateFailure(e);
                }
                this.sleepIfRequired();
            }
            Object var3_2 = null;
            this.paused = false;
            this.running = false;
            this.afterShutdown();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.paused = false;
            this.running = false;
            this.afterShutdown();
            throw throwable;
        }
    }

    protected void beforeStart() {
    }

    protected void afterShutdown() {
    }

    protected void handleIterateFailure(Exception e) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)"delegate Runnable occer exception", (Throwable)e);
        }
    }

    private void sleepIfRequired() {
        if (this.sleepInterval > 0L && this.running && !this.paused) {
            try {
                Thread.sleep(this.sleepInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pausedIfRequired() {
        if (this.paused && this.running) {
            LoopRunnable loopRunnable = this;
            synchronized (loopRunnable) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

