/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.util;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.metadata.ConstraintDescriptor;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationErrorsUtils {
    private static final Set<String> internalAnnotationAttributes = new HashSet<String>(3);

    public static void convert(ConstraintViolationException exception, Errors errors) {
        ValidationErrorsUtils.convert(exception.getConstraintViolations(), errors);
    }

    public static void convert(Set<ConstraintViolation<?>> constraintViolations, Errors errors) {
        for (ConstraintViolation<?> violation : constraintViolations) {
            String field = violation.getPropertyPath().toString();
            FieldError fieldError = errors.getFieldError(field);
            if (fieldError != null && fieldError.isBindingFailure()) continue;
            try {
                errors.rejectValue(field, violation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName(), ValidationErrorsUtils.getArgumentsForConstraint(errors.getObjectName(), field, violation.getConstraintDescriptor()), violation.getMessage());
            }
            catch (NotReadablePropertyException ex) {
                throw new IllegalStateException("JSR-303 validated property '" + field + "' does not have a corresponding accessor for Spring data binding - " + "check your DataBinder's configuration (bean property versus direct field access)", ex);
            }
        }
    }

    protected static Object[] getArgumentsForConstraint(String objectName, String field, ConstraintDescriptor<?> descriptor) {
        LinkedList<Object> arguments = new LinkedList<Object>();
        String[] codes = new String[]{objectName + "." + field, field};
        arguments.add(new DefaultMessageSourceResolvable(codes, field));
        TreeMap attributesToExpose = new TreeMap();
        for (Map.Entry entry : descriptor.getAttributes().entrySet()) {
            String attributeName = (String)entry.getKey();
            Object attributeValue = entry.getValue();
            if (internalAnnotationAttributes.contains(attributeName)) continue;
            attributesToExpose.put(attributeName, attributeValue);
        }
        arguments.addAll(attributesToExpose.values());
        return arguments.toArray(new Object[arguments.size()]);
    }

    static {
        internalAnnotationAttributes.add("message");
        internalAnnotationAttributes.add("groups");
        internalAnnotationAttributes.add("payload");
    }
}

