/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.util.holder;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;

public class MessageSourceHolder
implements MessageSourceAware {
    private static Log log = LogFactory.getLog(MessageSourceHolder.class);
    private static MessageSource messageSource;

    public void setMessageSource(MessageSource message) throws BeansException {
        if (messageSource != null) {
            throw new IllegalStateException("MessageSourceHolder already holded 'messageSource'.");
        }
        messageSource = message;
        log.info((Object)("holded messageSource,displayName:" + messageSource));
    }

    public static MessageSource getMessageSource() {
        if (messageSource == null) {
            throw new IllegalStateException("'messageSource' property is null,MessageSourceHolder not yet init.");
        }
        return messageSource;
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        return MessageSourceHolder.getMessageSource().getMessage(resolvable, locale);
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return MessageSourceHolder.getMessageSource().getMessage(code, args, locale);
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return MessageSourceHolder.getMessageSource().getMessage(code, args, defaultMessage, locale);
    }

    public static void cleanHolder() {
        messageSource = null;
    }
}

