/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.util.page;

import java.io.Serializable;
import java.util.ArrayList;

public class Paginator
implements Serializable {
    private static final long serialVersionUID = 6089482156906595931L;
    private static final int DEFAULT_SLIDERS_COUNT = 7;
    private int pageSize;
    private int page;
    private int totalItems;

    public Paginator(int page, int pageSize, int totalItems) {
        this.pageSize = pageSize;
        this.totalItems = totalItems;
        this.page = this.computePageNo(page);
    }

    public int getPage() {
        return this.page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public boolean isFirstPage() {
        return this.page <= 1;
    }

    public boolean isLastPage() {
        return this.page >= this.getTotalPages();
    }

    public int getPrePage() {
        if (this.isHasPrePage()) {
            return this.page - 1;
        }
        return this.page;
    }

    public int getNextPage() {
        if (this.isHasNextPage()) {
            return this.page + 1;
        }
        return this.page;
    }

    public boolean isDisabledPage(int page) {
        return page < 1 || page > this.getTotalPages() || page == this.page;
    }

    public boolean isHasPrePage() {
        return this.page - 1 >= 1;
    }

    public boolean isHasNextPage() {
        return this.page + 1 <= this.getTotalPages();
    }

    public int getStartRow() {
        if (this.getPageSize() <= 0 || this.totalItems <= 0) {
            return 0;
        }
        return this.page > 0 ? (this.page - 1) * this.getPageSize() + 1 : 0;
    }

    public int getEndRow() {
        return this.page > 0 ? Math.min(this.pageSize * this.page, this.getTotalItems()) : 0;
    }

    public int getOffset() {
        return this.page > 0 ? (this.page - 1) * this.getPageSize() : 0;
    }

    public int getLimit() {
        if (this.page > 0) {
            return Math.min(this.pageSize * this.page, this.getTotalItems()) - this.pageSize * (this.page - 1);
        }
        return 0;
    }

    public int getTotalPages() {
        if (this.totalItems <= 0) {
            return 0;
        }
        if (this.pageSize <= 0) {
            return 0;
        }
        int count = this.totalItems / this.pageSize;
        if (this.totalItems % this.pageSize > 0) {
            ++count;
        }
        return count;
    }

    protected int computePageNo(int page) {
        return Paginator.computePageNumber(page, this.pageSize, this.totalItems);
    }

    public Integer[] getSlider() {
        return this.slider(7);
    }

    public Integer[] slider(int slidersCount) {
        return Paginator.generateLinkPageNumbers(this.getPage(), this.getTotalPages(), slidersCount);
    }

    private static int computeLastPageNumber(int totalItems, int pageSize) {
        int result;
        if (pageSize <= 0) {
            return 1;
        }
        int n = result = totalItems % pageSize == 0 ? totalItems / pageSize : totalItems / pageSize + 1;
        if (result <= 1) {
            result = 1;
        }
        return result;
    }

    private static int computePageNumber(int page, int pageSize, int totalItems) {
        if (page <= 1) {
            return 1;
        }
        if (Integer.MAX_VALUE == page || page > Paginator.computeLastPageNumber(totalItems, pageSize)) {
            return Paginator.computeLastPageNumber(totalItems, pageSize);
        }
        return page;
    }

    private static Integer[] generateLinkPageNumbers(int currentPageNumber, int lastPageNumber, int count) {
        int endPageNumber;
        int avg = count / 2;
        int startPageNumber = currentPageNumber - avg;
        if (startPageNumber <= 0) {
            startPageNumber = 1;
        }
        if ((endPageNumber = startPageNumber + count - 1) > lastPageNumber) {
            endPageNumber = lastPageNumber;
        }
        if (endPageNumber - startPageNumber < count && (startPageNumber = endPageNumber - count) <= 0) {
            startPageNumber = 1;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = startPageNumber; i <= endPageNumber; ++i) {
            result.add(new Integer(i));
        }
        return result.toArray(new Integer[result.size()]);
    }

    public String toString() {
        return "page:" + this.page + " pageSize:" + this.pageSize + " totalItems:" + this.totalItems;
    }
}

