/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.web.session.store;

import cn.org.rapid_framework.cache.Cache;
import cn.org.rapid_framework.web.session.store.SessionStore;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CacheSessionStore
extends SessionStore
implements InitializingBean {
    private Cache cache;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)"cache must be not null");
    }

    public void deleteSession(String sessionId) {
        this.cache.delete(sessionId);
    }

    public Map getSession(String sessionId, int timeoutSeconds) {
        HashMap result = (HashMap)this.get(sessionId);
        if (result == null) {
            result = new HashMap();
        }
        return result;
    }

    private Object get(String sessionId) {
        return this.cache.get(sessionId);
    }

    public void saveSession(String sessionId, Map sessionData, int timeoutSeconds) {
        this.cache.set(sessionId, sessionData, timeoutSeconds);
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }
}

