/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.freemarker.loader;

import cn.org.rapid_framework.freemarker.FreemarkerTemplateException;
import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DataSourceTemplateLoader
implements TemplateLoader,
InitializingBean {
    Log log = LogFactory.getLog(DataSourceTemplateLoader.class);
    private JdbcTemplate jdbcTemplate;
    private String tableName;
    private String templateNameColumn;
    private String templateContentColumn;
    private String timestampColumn;

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setTemplateNameColumn(String column) {
        this.templateNameColumn = column;
    }

    public void setTemplateContentColumn(String templateContentColumn) {
        this.templateContentColumn = templateContentColumn;
    }

    public void setTimestampColumn(String timestampColumn) {
        this.timestampColumn = timestampColumn;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jdbcTemplate, (String)"'dataSource' must be not null");
        Assert.hasText((String)this.tableName, (String)"'tableName' must be not blank");
        Assert.hasText((String)this.templateNameColumn, (String)"'templateNameColumn' must be not blank");
        Assert.hasText((String)this.templateContentColumn, (String)"'templateContentColumn' must be not blank");
        this.log.info((Object)("Freemarker template load sql:" + this.getSql(this.templateContentColumn)));
    }

    public Object findTemplateSource(String name) throws IOException {
        int count = this.getJdbcTemplate().queryForInt(this.getSql("count(*)"), new Object[]{name});
        return count > 0 ? name : null;
    }

    private String getSql(String columnNames) {
        return "select " + columnNames + " from " + this.tableName + " where " + this.templateNameColumn + "=?";
    }

    public Reader getReader(Object templateSource, final String encoding) throws IOException {
        final String templateName = (String)templateSource;
        return (Reader)this.getJdbcTemplate().query(this.getSql(this.templateContentColumn), new Object[]{templateName}, new ResultSetExtractor(){

            public Reader extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    try {
                        Object obj = rs.getObject(DataSourceTemplateLoader.this.templateContentColumn);
                        if (obj instanceof String) {
                            return new StringReader((String)obj);
                        }
                        if (obj instanceof Clob) {
                            return new StringReader(rs.getString(DataSourceTemplateLoader.this.templateContentColumn));
                        }
                        if (obj instanceof InputStream) {
                            return new InputStreamReader((InputStream)obj, encoding);
                        }
                        if (obj instanceof Blob) {
                            return new InputStreamReader(rs.getBinaryStream(DataSourceTemplateLoader.this.templateContentColumn), encoding);
                        }
                        throw new FreemarkerTemplateException("error sql type of templateContentColumn:" + DataSourceTemplateLoader.this.templateContentColumn);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new FreemarkerTemplateException("load template from dataSource with templateName:" + templateName + " occer UnsupportedEncodingException", e);
                    }
                }
                throw new FreemarkerTemplateException("not found template from dataSource with templateName:" + templateName);
            }
        });
    }

    public long getLastModified(Object templateSource) {
        if (StringUtils.hasText((String)this.timestampColumn)) {
            String templateName = (String)templateSource;
            Object timestamp = this.getJdbcTemplate().queryForObject(this.getSql(this.timestampColumn), new Object[]{templateName}, (RowMapper)new SingleColumnRowMapper());
            if (timestamp instanceof Number) {
                return ((Number)timestamp).longValue();
            }
            if (timestamp instanceof Date) {
                return ((Date)timestamp).getTime();
            }
            throw new FreemarkerTemplateException("error template timestamp column type,must be Date or Number type");
        }
        return -1L;
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
    }
}

