/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.io;

import cn.org.rapid_framework.io.AsyncExceptinHandler;
import cn.org.rapid_framework.io.BufferCopyUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncWriter
extends Writer {
    private static Log log = LogFactory.getLog(AsyncWriter.class);
    private static final int DEFAULT_QUEUE_CAPACITY = 50000;
    private static final char[] CLOSED_SIGNEL = new char[0];
    private Writer out;
    private DataProcessorThread dataProcessor;
    private boolean isClosed = false;
    private boolean isStartd = false;
    private BlockingQueue<char[]> queue;
    private AsyncExceptinHandler asyncExceptinHandler = new AsyncExceptinHandler.DefaultAsyncExceptinHandler();
    private static long threadSeqNumber;

    private static synchronized long nextThreadID() {
        return ++threadSeqNumber;
    }

    public AsyncWriter(Writer out) {
        this(out, 50000, 6);
    }

    public AsyncWriter(Writer out, int queueCapacity) {
        this(out, queueCapacity, 6);
    }

    public AsyncWriter(Writer out, int queueCapacity, int dataProcesserThreadPriority) {
        this(out, new ArrayBlockingQueue(queueCapacity), dataProcesserThreadPriority);
    }

    public AsyncWriter(Writer out, BlockingQueue queue, int dataProcesserThreadPriority) {
        if (out == null) {
            throw new NullPointerException();
        }
        if (queue == null) {
            throw new NullPointerException();
        }
        this.queue = queue;
        this.dataProcessor = new DataProcessorThread();
        if (dataProcesserThreadPriority != 5) {
            this.dataProcessor.setPriority(dataProcesserThreadPriority);
        }
        this.out = out;
    }

    public AsyncWriter(Writer out, AsyncExceptinHandler handler) {
        this(out);
        this.setAsyncExceptinHandler(handler);
    }

    public void start() {
        this.dataProcessor.start();
        this.isStartd = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf, int offset, int length) throws IOException {
        if (!this.isStartd) {
            throw new IOException("must start() before wirte()");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException("already closed");
            }
            try {
                this.queue.put(BufferCopyUtils.copyBuffer(buf, offset, length));
            }
            catch (InterruptedException e) {
                throw new IOException("AsyncWriter occer InterruptedException error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.isClosed = true;
                this.dataProcessor.enabled = false;
                if (this.queue.isEmpty()) {
                    this.queue.offer(CLOSED_SIGNEL);
                }
                try {
                    this.dataProcessor.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.dataProcessor.hasRuned) {
                    this.dataProcessor.run();
                }
            }
            finally {
                this.out.close();
            }
        }
    }

    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceFlush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (this.queue.size() > 0) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.out.flush();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isClosed) {
            log.warn((Object)("AsyncWriter not close:" + this));
            this.close();
        }
    }

    public void setAsyncExceptinHandler(AsyncExceptinHandler asyncExceptinHandler) {
        if (asyncExceptinHandler == null) {
            throw new NullPointerException();
        }
        this.asyncExceptinHandler = asyncExceptinHandler;
    }

    private class DataProcessorThread
    extends Thread {
        private boolean enabled;
        private boolean hasRuned;

        DataProcessorThread() {
            super("AsyncWriter.DataProcessorThread-" + AsyncWriter.nextThreadID());
            this.enabled = true;
            this.hasRuned = false;
            this.setDaemon(true);
        }

        public void run() {
            this.hasRuned = true;
            while (this.enabled || !AsyncWriter.this.queue.isEmpty()) {
                char[] buf;
                try {
                    buf = (char[])AsyncWriter.this.queue.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                if (buf == CLOSED_SIGNEL) {
                    return;
                }
                try {
                    AsyncWriter.this.out.write(buf);
                }
                catch (IOException e) {
                    AsyncWriter.this.asyncExceptinHandler.handle(e);
                }
            }
        }
    }
}

