/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.pipeline;

import cn.org.rapid_framework.pipeline.PipeException;
import cn.org.rapid_framework.pipeline.Pipeline;
import cn.org.rapid_framework.util.StringTokenizerUtils;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class FreemarkerPipeline
implements Pipeline {
    private Configuration conf;
    private int bufferSize = 4096;

    public FreemarkerPipeline() {
    }

    public FreemarkerPipeline(Configuration conf) {
        this.setConfiguration(conf);
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public void setConfiguration(Configuration conf) {
        this.conf = conf;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public Writer pipeline(String[] pipeTemplates, Object rootMap, Writer writer) throws PipeException {
        try {
            HashMap<String, String> globalContext = new HashMap<String, String>();
            for (int i = 0; i < pipeTemplates.length; ++i) {
                String templateName = pipeTemplates[i];
                boolean isLastTemplate = i == pipeTemplates.length - 1;
                try {
                    Template template = this.conf.getTemplate(templateName);
                    if (isLastTemplate) {
                        Environment env = template.createProcessingEnvironment(rootMap, writer);
                        env.getCurrentNamespace().putAll(globalContext);
                        env.process();
                        continue;
                    }
                    StringWriter tempOutput = new StringWriter(this.bufferSize);
                    Environment env = template.createProcessingEnvironment(rootMap, (Writer)tempOutput);
                    env.getCurrentNamespace().putAll(globalContext);
                    env.process();
                    globalContext.putAll(env.getCurrentNamespace().toMap());
                    globalContext.put("pipeline_content", ((Object)tempOutput).toString());
                    continue;
                }
                catch (Exception e) {
                    this.handleException(e, templateName, isLastTemplate);
                }
            }
            return writer;
        }
        catch (Exception e) {
            throw new PipeException("process FreeMarker template occer exception,pipeTemplates:" + StringUtils.join((Object[])pipeTemplates, (String)" | "), e);
        }
    }

    public void handleException(Exception e, String templateName, boolean isLastTemplate) throws Exception {
        throw e;
    }

    public Writer pipeline(String[] pipeTemplates, Map model, Writer writer) throws PipeException {
        return this.pipeline(pipeTemplates, (Object)model, writer);
    }

    public Writer pipeline(String pipeTemplates, Object rootMap, Writer writer) {
        return this.pipeline(StringTokenizerUtils.split(pipeTemplates, ",| "), rootMap, writer);
    }

    public Writer pipeline(String pipeTemplates, Map model, Writer writer) throws PipeException {
        return this.pipeline(pipeTemplates, (Object)model, writer);
    }
}

