/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.struts;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.ModuleUtils;

public class DevModeActionServlet
extends ActionServlet {
    private static String DEFAULT_STRUTS_CONFIG_NAME = "struts1.properties";
    private static Properties properties = new Properties();
    private static boolean devMode;

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (devMode) {
            log.info((Object)"start reload struts config");
            ModuleUtils.getInstance().selectModule(request, this.getServletContext());
            ModuleConfig config = this.getModuleConfig(request);
            String key = "org.apache.struts.action.REQUEST_PROCESSOR" + config.getPrefix();
            this.destroy();
            this.init(this.getServletConfig());
            this.getServletContext().setAttribute(key, null);
        }
        super.process(request, response);
    }

    static {
        try {
            InputStream strutsConfigIn = DevModeActionServlet.class.getClassLoader().getResourceAsStream(DEFAULT_STRUTS_CONFIG_NAME);
            if (strutsConfigIn != null) {
                log.info((Object)("load " + DEFAULT_STRUTS_CONFIG_NAME + " file in classpath"));
                properties.load(strutsConfigIn);
                strutsConfigIn.close();
            } else {
                log.info((Object)("not found " + DEFAULT_STRUTS_CONFIG_NAME + " file in classpath"));
            }
        }
        catch (Exception e) {
            log.warn((Object)("count not load " + DEFAULT_STRUTS_CONFIG_NAME + ",cause=" + e.toString()), (Throwable)e);
        }
        devMode = Boolean.valueOf(properties.getProperty("devMode", "false"));
        log.info((Object)("struts devMode=" + devMode));
    }
}

