/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.struts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class StrutsMessageUtil {
    public static boolean hasMessage(HttpServletRequest request) {
        ActionMessages messages = StrutsMessageUtil.getMessages(request);
        return messages != null && !messages.isEmpty();
    }

    public static boolean hasError(HttpServletRequest request) {
        ActionMessages errors = StrutsMessageUtil.getErrors(request);
        return errors != null && !errors.isEmpty();
    }

    public static void addError(HttpServletRequest request, String key, ActionError error) {
        ActionMessages errors = StrutsMessageUtil.getErrors(request);
        if (errors == null) {
            errors = new ActionErrors();
        }
        errors.add(key, (ActionMessage)error);
        StrutsMessageUtil.saveErrors(request, errors);
    }

    public static void addError(HttpServletRequest request, String key, String errorKey) {
        ActionMessages errors = StrutsMessageUtil.getErrors(request);
        if (errors == null) {
            errors = new ActionErrors();
        }
        errors.add(key, (ActionMessage)new ActionError(errorKey));
        StrutsMessageUtil.saveErrors(request, errors);
    }

    public static void addMessage(HttpServletRequest request, ActionMessage message) {
        StrutsMessageUtil.addMessage(request, "org.apache.struts.action.GLOBAL_MESSAGE", message);
    }

    public static void addMessage(HttpServletRequest request, String msgKey) {
        StrutsMessageUtil.addMessage(request, new ActionMessage(msgKey));
    }

    public static void addMessage(HttpServletRequest request, String key, ActionMessage message) {
        ActionMessages messages = StrutsMessageUtil.getMessages(request);
        if (messages == null) {
            messages = new ActionMessages();
        }
        messages.add(key, message);
        StrutsMessageUtil.saveMessages(request, messages);
    }

    public static void addError(HttpServletRequest request, ActionError error) {
        StrutsMessageUtil.addError(request, "org.apache.struts.action.GLOBAL_ERROR", error);
    }

    public static void addError(HttpServletRequest request, String msgKey) {
        StrutsMessageUtil.addError(request, "org.apache.struts.action.GLOBAL_ERROR", new ActionError(msgKey));
    }

    public static ActionMessages getErrors(HttpServletRequest request) {
        ActionErrors errors = null;
        HttpSession session = request.getSession(false);
        if (request.getAttribute("org.apache.struts.action.ERROR") != null) {
            errors = (ActionErrors)request.getAttribute("org.apache.struts.action.ERROR");
        } else if (session != null && session.getAttribute("org.apache.struts.action.ERROR") != null) {
            errors = (ActionErrors)session.getAttribute("org.apache.struts.action.ERROR");
        } else {
            errors = new ActionErrors();
            StrutsMessageUtil.saveErrors(request, (ActionMessages)errors);
        }
        return errors;
    }

    public static ActionMessages getMessages(HttpServletRequest request) {
        ActionMessages messages = null;
        HttpSession session = request.getSession();
        if (request.getAttribute("org.apache.struts.action.ACTION_MESSAGE") != null) {
            messages = (ActionMessages)request.getAttribute("org.apache.struts.action.ACTION_MESSAGE");
        } else if (session.getAttribute("org.apache.struts.action.ACTION_MESSAGE") != null) {
            messages = (ActionMessages)session.getAttribute("org.apache.struts.action.ACTION_MESSAGE");
        } else {
            messages = new ActionMessages();
            StrutsMessageUtil.saveMessages(request, messages);
        }
        return messages;
    }

    public static void saveErrors(HttpServletRequest request, ActionMessages errors) {
        if (errors == null || errors.isEmpty()) {
            request.removeAttribute("org.apache.struts.action.ERROR");
            return;
        }
        request.getSession().setAttribute("org.apache.struts.action.ERROR", (Object)errors);
    }

    public static void saveMessages(HttpServletRequest request, ActionMessages messages) {
        if (messages == null || messages.isEmpty()) {
            request.removeAttribute("org.apache.struts.action.ACTION_MESSAGE");
            return;
        }
        request.getSession().setAttribute("org.apache.struts.action.ACTION_MESSAGE", (Object)messages);
    }
}

