/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public class SqlRemoveUtils {
    private static int indexOfByRegex(String input, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        if (m.find()) {
            return m.start();
        }
        return -1;
    }

    public static String removeSelect(String sql) {
        Assert.hasText((String)sql);
        int beginPos = SqlRemoveUtils.indexOfByRegex(sql.toLowerCase(), "\\sfrom\\s");
        Assert.isTrue((beginPos != -1 ? 1 : 0) != 0, (String)(" sql : " + sql + " must has a keyword 'from'"));
        return sql.substring(beginPos);
    }

    public static String removeOrders(String sql) {
        Assert.hasText((String)sql);
        Pattern p = Pattern.compile("order\\s*by[\\w|\\W|\\s|\\S]*", 2);
        Matcher m = p.matcher(sql);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String removeFetchKeyword(String sql) {
        return sql.replaceAll("(?i)fetch", "");
    }

    public static String removeXsqlBuilderOrders(String string) {
        Assert.hasText((String)string);
        Pattern p = Pattern.compile("/~.*order\\s*by[\\w|\\W|\\s|\\S]*~/", 2);
        Matcher m = p.matcher(string);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return SqlRemoveUtils.removeOrders(sb.toString());
    }
}

