/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.util.concurrent.async;

import cn.org.rapid_framework.util.concurrent.async.AsyncToken;
import java.util.concurrent.Callable;

public class AsyncTokenRunnable
implements Runnable {
    AsyncToken asyncToken;
    Runnable targetRunnable;
    Callable targetCallable;

    public AsyncTokenRunnable(AsyncToken asyncToken, Runnable target) {
        if (asyncToken == null) {
            throw new IllegalArgumentException("asyncToken must be not null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target Runnable must be not null");
        }
        this.asyncToken = asyncToken;
        this.targetRunnable = target;
    }

    public AsyncTokenRunnable(AsyncToken asyncToken, Callable target) {
        if (asyncToken == null) {
            throw new IllegalArgumentException("asyncToken must be not null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target Callable must be not null");
        }
        this.asyncToken = asyncToken;
        this.targetCallable = target;
    }

    public AsyncToken getAsyncToken() {
        return this.asyncToken;
    }

    public void run() {
        try {
            if (this.targetRunnable == null) {
                this.asyncToken.setComplete(this.targetCallable.call());
            } else {
                this.targetRunnable.run();
                this.asyncToken.setComplete();
            }
        }
        catch (Exception e) {
            this.asyncToken.setFault(e);
        }
    }
}

