/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.util.holder;

import cn.org.rapid_framework.cache.Cache;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheHolder
implements InitializingBean {
    static Log logger = LogFactory.getLog(CacheHolder.class);
    private static Cache cache;
    static Pattern days;
    static Pattern hours;
    static Pattern minutes;
    static Pattern seconds;

    public void afterPropertiesSet() throws Exception {
        if (cache == null) {
            throw new IllegalStateException("not found 'cache' for CacheHolder ");
        }
    }

    public void setCache(Cache c) {
        if (cache != null) {
            throw new IllegalStateException("CacheHolder already holded 'cache'");
        }
        cache = c;
    }

    public static void add(String key, Object value, String expiration) {
        CacheHolder.checkSerializable(value);
        cache.add(key, value, CacheHolder.parseDuration(expiration));
    }

    public static boolean safeAdd(String key, Object value, String expiration) {
        CacheHolder.checkSerializable(value);
        return cache.safeAdd(key, value, CacheHolder.parseDuration(expiration));
    }

    public static void add(String key, Object value) {
        CacheHolder.checkSerializable(value);
        cache.add(key, value, CacheHolder.parseDuration(null));
    }

    public static void set(String key, Object value, String expiration) {
        CacheHolder.checkSerializable(value);
        cache.set(key, value, CacheHolder.parseDuration(expiration));
    }

    public static boolean safeSet(String key, Object value, String expiration) {
        CacheHolder.checkSerializable(value);
        return cache.safeSet(key, value, CacheHolder.parseDuration(expiration));
    }

    public static void set(String key, Object value) {
        CacheHolder.checkSerializable(value);
        cache.set(key, value, CacheHolder.parseDuration(null));
    }

    public static void replace(String key, Object value, String expiration) {
        CacheHolder.checkSerializable(value);
        cache.replace(key, value, CacheHolder.parseDuration(expiration));
    }

    public static boolean safeReplace(String key, Object value, String expiration) {
        CacheHolder.checkSerializable(value);
        return cache.safeReplace(key, value, CacheHolder.parseDuration(expiration));
    }

    public static void replace(String key, Object value) {
        CacheHolder.checkSerializable(value);
        cache.replace(key, value, CacheHolder.parseDuration(null));
    }

    public static long incr(String key, int by) {
        return cache.incr(key, by);
    }

    public static long incr(String key) {
        return cache.incr(key, 1);
    }

    public static long decr(String key, int by) {
        return cache.decr(key, by);
    }

    public static long decr(String key) {
        return cache.decr(key, 1);
    }

    public static Object get(String key) {
        return cache.get(key);
    }

    public static Map<String, Object> get(String ... key) {
        return cache.get(key);
    }

    public static void delete(String key) {
        cache.delete(key);
    }

    public static boolean safeDelete(String key) {
        return cache.safeDelete(key);
    }

    public static void clear() {
        cache.clear();
    }

    public static <T> T get(String key, Class<T> clazz) {
        return (T)cache.get(key);
    }

    public static void stop() {
        cache.stop();
    }

    public static void cleanHolder() {
        cache = null;
    }

    static void checkSerializable(Object value) {
        if (!(value instanceof Serializable)) {
            throw new IllegalStateException("Cannot cache a non-serializable value of type " + value.getClass().getName(), new NotSerializableException(value.getClass().getName()));
        }
    }

    public static int parseDuration(String duration) {
        if (duration == null) {
            return 2592000;
        }
        int toAdd = -1;
        if (days.matcher(duration).matches()) {
            Matcher matcher = days.matcher(duration);
            matcher.matches();
            toAdd = Integer.parseInt(matcher.group(1)) * 3600 * 24;
        } else if (hours.matcher(duration).matches()) {
            Matcher matcher = hours.matcher(duration);
            matcher.matches();
            toAdd = Integer.parseInt(matcher.group(1)) * 3600;
        } else if (minutes.matcher(duration).matches()) {
            Matcher matcher = minutes.matcher(duration);
            matcher.matches();
            toAdd = Integer.parseInt(matcher.group(1)) * 60;
        } else if (seconds.matcher(duration).matches()) {
            Matcher matcher = seconds.matcher(duration);
            matcher.matches();
            toAdd = Integer.parseInt(matcher.group(1));
        }
        if (toAdd == -1) {
            throw new IllegalArgumentException("Invalid duration pattern : " + duration);
        }
        return toAdd;
    }

    static {
        days = Pattern.compile("^([0-9]+)d$");
        hours = Pattern.compile("^([0-9]+)h$");
        minutes = Pattern.compile("^([0-9]+)mn$");
        seconds = Pattern.compile("^([0-9]+)s$");
    }
}

