/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.web.scope;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flash {
    private static final String FLASH_IN_SESSION_KEY = "__flash__";
    private Map<String, String> data = new HashMap<String, String>();
    private Map<String, String> out = new HashMap<String, String>();
    private static ThreadLocal<Flash> current = new ThreadLocal();

    public static Flash restore(HttpServletRequest request) {
        Flash flash = new Flash();
        HttpSession session = request.getSession();
        Map flashData = (Map)session.getAttribute(FLASH_IN_SESSION_KEY);
        if (flashData != null) {
            flash.data = flashData;
        }
        return flash;
    }

    public void save(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        if (session != null) {
            session.setAttribute(FLASH_IN_SESSION_KEY, this.out);
        }
    }

    public static Flash current() {
        return current.get();
    }

    static void setCurrent(Flash f) {
        current.set(f);
    }

    public void put(String key, String value) {
        if (key.contains(":")) {
            throw new IllegalArgumentException("Character ':' is invalid in a flash key.");
        }
        this.data.put(key, value);
        this.out.put(key, value);
    }

    public void now(String key, String value) {
        if (key.contains(":")) {
            throw new IllegalArgumentException("Character ':' is invalid in a flash key.");
        }
        this.data.put(key, value);
    }

    public void put(String key, Object value) {
        if (value == null) {
            this.put(key, null);
        }
        this.put(key, value + "");
    }

    public void error(String value, Object ... args) {
        this.put("error", String.format(value, args));
    }

    public void success(String value, Object ... args) {
        this.put("success", String.format(value, args));
    }

    public void discard(String key) {
        this.out.remove(key);
    }

    public void discard() {
        this.out.clear();
    }

    public void keep(String key) {
        if (this.data.containsKey(key)) {
            this.out.put(key, this.data.get(key));
        }
    }

    public void keep() {
        this.out.putAll(this.data);
    }

    public String get(String key) {
        return this.data.get(key);
    }

    public boolean remove(String key) {
        return this.data.remove(key) != null;
    }

    public void clear() {
        this.data.clear();
    }

    public boolean contains(String key) {
        return this.data.containsKey(key);
    }

    public String toString() {
        return this.data.toString();
    }

    public Map<String, String> getData() {
        return this.data;
    }
}

