/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.web.session.store;

import cn.org.rapid_framework.web.session.store.SessionStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcSessionStore
extends SessionStore {
    DataSource dataSource;
    static String DELETE = "delete from http_session_store where session_id = ?";
    static String INSERT = "insert into http_session_store(session_id,expire_date,session_data) values (?,?,?)";
    static String GET = "select session_data from http_session_store where session_id = ? and expire_date >= ?";
    static Pattern sessionDataParser = Pattern.compile("\u0000([^:]*):([^\u0000]*)\u0000");

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void deleteSession(String sessionId) {
        this.getSimpleJdbcTemplate().update(DELETE, new Object[]{sessionId});
    }

    @Override
    public Map getSession(String sessionId, int timeoutSeconds) {
        List results = this.getSimpleJdbcTemplate().query(GET, (ParameterizedRowMapper)new ParameterizedRowMapper<Map>(){

            public Map mapRow(ResultSet rs, int row) throws SQLException {
                String sessionData = rs.getString(1);
                return JdbcSessionStore.decode(sessionData);
            }
        }, new Object[]{sessionId, System.currentTimeMillis()});
        return results.size() > 0 ? (Map)results.get(0) : new HashMap();
    }

    @Override
    public void saveSession(String sessionId, Map sessionData, int timeoutSeconds) {
        this.deleteSession(sessionId);
        String data = JdbcSessionStore.encode(sessionData);
        Timestamp expire_date = this.computeExpireDate(timeoutSeconds);
        this.getSimpleJdbcTemplate().update(INSERT, new Object[]{sessionId, expire_date.getTime(), data});
    }

    private Timestamp computeExpireDate(int timeoutSeconds) {
        return new Timestamp(System.currentTimeMillis() + (long)(timeoutSeconds * 1000));
    }

    private SimpleJdbcTemplate getSimpleJdbcTemplate() {
        return new SimpleJdbcTemplate(this.dataSource);
    }

    public static Map decode(String sessionData) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(new BASE64Decoder().decodeBuffer(sessionData)));
            return (Map)ois.readObject();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("decode session data error:UnsupportedEncodingException", e);
        }
        catch (IOException e) {
            throw new RuntimeException("decode session data error:IOException", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("decode session data error:ClassNotFoundException", e);
        }
    }

    public static String encode(Map<String, ?> sessionData) {
        try {
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(byteOutput);
            oos.writeObject(sessionData);
            byte[] bytes = byteOutput.toByteArray();
            return new BASE64Encoder().encode(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("encode session data error", e);
        }
    }
}

