/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.web.session.store;

import cn.org.rapid_framework.web.session.store.SessionStore;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.transcoders.SerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import org.springframework.beans.factory.InitializingBean;

public class MemcachedSessionStore
extends SessionStore
implements InitializingBean {
    private MemcachedClient client;
    private SerializingTranscoder serializingTranscoder = new SerializingTranscoder();
    private String hosts = null;

    public void afterPropertiesSet() throws Exception {
        System.setProperty("net.spy.log.LoggerImpl", "net.spy.memcached.compat.log.Log4JLogger");
        if (this.client == null) {
            this.client = new MemcachedClient(AddrUtil.getAddresses((String)this.hosts));
        }
    }

    public void setSerializingTranscoder(SerializingTranscoder serializingTranscoder) {
        this.serializingTranscoder = serializingTranscoder;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public void setClient(MemcachedClient memcachedClient) {
        this.client = memcachedClient;
    }

    public void deleteSession(String sessionId) {
        Future future = this.client.delete(sessionId);
    }

    public Map getSession(String sessionId, int timeoutSeconds) {
        HashMap result = (HashMap)this.get(sessionId);
        if (result == null) {
            result = new HashMap();
        }
        return result;
    }

    private Object get(String sessionId) {
        Future f = this.client.asyncGet(sessionId, (Transcoder)this.serializingTranscoder);
        try {
            return f.get(1L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            f.cancel(false);
            return null;
        }
    }

    public void saveSession(String sessionId, Map sessionData, int timeoutSeconds) {
        Future future = this.client.set(sessionId, timeoutSeconds, (Object)sessionData, (Transcoder)this.serializingTranscoder);
    }
}

