/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.web.util;

import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;

public class HttpUtils {
    public static Hashtable parseQueryString(String s) {
        String[] valArray = null;
        if (s == null) {
            throw new IllegalArgumentException("queryString must not null");
        }
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>();
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s, "&");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            if (pair.trim().length() == 0) continue;
            int pos = pair.indexOf(61);
            if (pos == -1) {
                throw new IllegalArgumentException("cannot parse queryString:" + s);
            }
            String key = HttpUtils.parseName(pair.substring(0, pos), sb);
            String val = HttpUtils.parseName(pair.substring(pos + 1, pair.length()), sb);
            if (ht.containsKey(key)) {
                String[] oldVals = (String[])ht.get(key);
                valArray = new String[oldVals.length + 1];
                for (int i = 0; i < oldVals.length; ++i) {
                    valArray[i] = oldVals[i];
                }
                valArray[oldVals.length] = val;
            } else {
                valArray = new String[]{val};
            }
            ht.put(key, valArray);
        }
        return HttpUtils.fixValueArray2SingleStringObject(ht);
    }

    private static Hashtable fixValueArray2SingleStringObject(Hashtable ht) {
        Hashtable result = new Hashtable();
        for (Map.Entry entry : ht.entrySet()) {
            String[] valueArray = (String[])entry.getValue();
            if (valueArray == null) {
                result.put(entry.getKey(), valueArray);
                continue;
            }
            result.put(entry.getKey(), (String[])(valueArray.length == 1 ? valueArray[0] : valueArray));
        }
        return result;
    }

    private static String parseName(String s, StringBuffer sb) {
        sb.setLength(0);
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    continue block7;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue block7;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        String rest = s.substring(i);
                        sb.append(rest);
                        if (rest.length() != 2) continue block7;
                        ++i;
                        continue block7;
                    }
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

