/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.concurrent;

import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.concurrent.TimeUnit;

public class ArrayBlockingQueue {
    protected Object[] buffer;
    protected int size;
    protected int front;
    protected int rear;
    protected boolean fcarry;
    protected boolean rcarry;
    protected Semaphore empty;
    protected Semaphore full;
    protected Object pt;
    protected Object gt;

    public ArrayBlockingQueue(int n) {
        if (n < 1) {
            throw new IllegalArgumentException(this.getClass().getName() + ".<init>(int init)\n\tParameter init must be greater than zero.");
        }
        this.buffer = new Object[n];
        this.size = n;
        this.front = 0;
        this.rear = 0;
        this.fcarry = false;
        this.rcarry = false;
        this.empty = new Semaphore(n, true);
        this.full = new Semaphore(0, true);
        this.pt = new Object();
        this.gt = new Object();
    }

    public boolean isEmpty() {
        return this.front == this.rear && this.fcarry == this.rcarry;
    }

    public boolean isFull() {
        return this.front == this.rear && this.fcarry != this.rcarry;
    }

    public synchronized int size() {
        int n = this.front;
        int n2 = this.rear;
        if (this.fcarry != this.rcarry || n2 < n) {
            n2 += this.size;
        }
        return n2 - n;
    }

    public int remainingCapacity() {
        return this.size - this.size();
    }

    protected void add(Object object) {
        this.buffer[this.rear] = object;
        ++this.rear;
        if (this.rear >= this.size) {
            this.rear -= this.size;
            this.rcarry = !this.rcarry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object) throws InterruptedException {
        this.empty.acquire();
        Object object2 = this.pt;
        synchronized (object2) {
            this.add(object);
        }
        this.full.release();
    }

    public boolean offer(Object object) {
        try {
            return this.offer(object, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object object, long l, TimeUnit timeUnit) throws InterruptedException {
        if (object == null) {
            throw new NullPointerException(this.getClass().getName() + ".offer(Object v,long timeout,TimeUnit unit)\n\tObject v is null.");
        }
        if (this.empty.tryAcquire(l, timeUnit)) {
            Object object2 = this.pt;
            synchronized (object2) {
                this.add(object);
            }
            this.full.release();
            return true;
        }
        return false;
    }

    protected Object remove() {
        Object object = this.buffer[this.front];
        ++this.front;
        if (this.front >= this.size) {
            this.front -= this.size;
            this.fcarry = !this.fcarry;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object take() throws InterruptedException {
        Object object;
        this.full.acquire();
        Object object2 = this.gt;
        synchronized (object2) {
            object = this.remove();
        }
        this.empty.release();
        return object;
    }

    public Object poll() {
        try {
            return this.poll(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll(long l, TimeUnit timeUnit) throws InterruptedException {
        Object object = null;
        if (this.full.tryAcquire(l, timeUnit)) {
            Object object2 = this.gt;
            synchronized (object2) {
                object = this.remove();
            }
            this.empty.release();
        }
        return object;
    }

    public void clear() {
        while (this.poll() != null) {
        }
    }
}

