/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.concurrent;

import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.concurrent.TimeUnit;

public class BufferBlockingQueue {
    protected Object[] buffer;
    protected int size;
    protected int front;
    protected int rear;
    protected boolean fcarry;
    protected boolean rcarry;
    protected Semaphore empty;
    protected Semaphore full;
    protected Object pt;
    protected Object gt;

    public BufferBlockingQueue(int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException(this.getClass().getName() + ".<init>(int init)\n\tParameter init must be greater than zero.");
        }
        this.buffer = new Object[n];
        for (int i = 0; i < n; ++i) {
            this.buffer[i] = new byte[n2];
        }
        this.size = n;
        this.front = 0;
        this.rear = 0;
        this.fcarry = false;
        this.rcarry = false;
        this.empty = new Semaphore(n, true);
        this.full = new Semaphore(0, true);
        this.pt = new Object();
        this.gt = new Object();
    }

    public boolean isEmpty() {
        return this.front == this.rear && this.fcarry == this.rcarry;
    }

    public boolean isFull() {
        return this.front == this.rear && this.fcarry != this.rcarry;
    }

    public int size() {
        int n = this.front;
        int n2 = this.rear;
        if (this.fcarry != this.rcarry || n2 < n) {
            n2 += this.size;
        }
        return n2 - n;
    }

    public int remainingCapacity() {
        return this.size - this.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(byte[] byArray) throws InterruptedException {
        this.empty.acquire();
        Object object = this.pt;
        synchronized (object) {
            byte[] byArray2 = (byte[])this.buffer[this.rear];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            ++this.rear;
            if (this.rear >= this.size) {
                this.rear -= this.size;
                this.rcarry = !this.rcarry;
            }
        }
        this.full.release();
    }

    public boolean offer(byte[] byArray) {
        try {
            return this.offer(byArray, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(byte[] byArray, long l, TimeUnit timeUnit) throws InterruptedException {
        if (byArray == null) {
            throw new NullPointerException(this.getClass().getName() + ".offer(byte[] v,long timeout,TimeUnit unit)\n\tbyte[] v is null.");
        }
        if (this.empty.tryAcquire(l, timeUnit)) {
            Object object = this.pt;
            synchronized (object) {
                byte[] byArray2 = (byte[])this.buffer[this.rear];
                System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                ++this.rear;
                if (this.rear >= this.size) {
                    this.rear -= this.size;
                    this.rcarry = !this.rcarry;
                }
            }
            this.full.release();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] take() throws InterruptedException {
        byte[] byArray;
        this.full.acquire();
        Object object = this.gt;
        synchronized (object) {
            byArray = (byte[])this.buffer[this.front];
            ++this.front;
            if (this.front >= this.size) {
                this.front -= this.size;
                this.fcarry = !this.fcarry;
            }
        }
        this.empty.release();
        return byArray;
    }

    public byte[] poll() {
        try {
            return this.poll(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] poll(long l, TimeUnit timeUnit) throws InterruptedException {
        byte[] byArray = null;
        if (this.full.tryAcquire(l, timeUnit)) {
            Object object = this.gt;
            synchronized (object) {
                byArray = (byte[])this.buffer[this.front];
                ++this.front;
                if (this.front >= this.size) {
                    this.front -= this.size;
                    this.fcarry = !this.fcarry;
                }
            }
            this.empty.release();
        }
        return byArray;
    }

    public void clear() {
        while (this.poll() != null) {
        }
    }
}

