/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import uk.co.mmscomputing.device.twain.TwainConstants;
import uk.co.mmscomputing.device.twain.TwainIOException;
import uk.co.mmscomputing.device.twain.TwainSource;
import uk.co.mmscomputing.device.twain.jtwain;

public class TwainImageInfo
implements TwainConstants {
    TwainSource source;
    byte[] buf = new byte[42];

    public TwainImageInfo(TwainSource twainSource) {
        this.source = twainSource;
    }

    public void get() throws TwainIOException {
        this.source.call(2, 257, 1, this.buf);
    }

    public double getXResolution() {
        return jtwain.getFIX32(this.buf, 0);
    }

    public double getYResolution() {
        return jtwain.getFIX32(this.buf, 4);
    }

    public int getWidth() {
        return jtwain.getINT32(this.buf, 8);
    }

    public int getHeight() {
        return jtwain.getINT32(this.buf, 12);
    }

    public int getSamplesPerPixel() {
        return jtwain.getINT16(this.buf, 16);
    }

    public int getBitsPerSample(int n) {
        return jtwain.getINT16(this.buf, 18 + n * 2);
    }

    public int getBitsPerPixel() {
        return jtwain.getINT16(this.buf, 34);
    }

    public boolean getPlanar() {
        return jtwain.getINT16(this.buf, 36) != 0;
    }

    public int getPixelType() {
        return jtwain.getINT16(this.buf, 38);
    }

    public int getCompression() {
        return jtwain.getINT16(this.buf, 40);
    }

    public String toString() {
        String string = "TwainImageInfo\n";
        string = string + "\tx-resolution =" + this.getXResolution() + "\n";
        string = string + "\ty-resolution =" + this.getYResolution() + "\n";
        string = string + "\twidth =" + this.getWidth() + "\n";
        string = string + "\theight=" + this.getHeight() + "\n";
        int n = this.getSamplesPerPixel();
        string = string + "\tspp=" + n + "\n";
        for (int i = 0; i < n; ++i) {
            string = string + "\tbps[" + i + "]=" + this.getBitsPerSample(i) + "\n";
        }
        string = string + "\tplanar=" + this.getPlanar() + "\n";
        string = string + "\tpixel type=" + this.getPixelType() + "\n";
        string = string + "\tcompression=" + this.getCompression() + "\n";
        return string;
    }
}

