/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import java.io.File;
import uk.co.mmscomputing.device.twain.TwainConstants;
import uk.co.mmscomputing.device.twain.TwainIOException;
import uk.co.mmscomputing.device.twain.TwainITransfer;
import uk.co.mmscomputing.device.twain.TwainSource;
import uk.co.mmscomputing.device.twain.TwainUserCancelException;
import uk.co.mmscomputing.device.twain.jtwain;

public class TwainTransfer
implements TwainConstants,
TwainITransfer {
    TwainSource source;
    boolean isCancelled;

    public TwainTransfer(TwainSource twainSource) {
        this.source = twainSource;
        this.isCancelled = false;
    }

    public void initiate() throws TwainIOException {
        this.commitCancel();
    }

    public void setCancel(boolean bl) {
        this.isCancelled = bl;
    }

    protected void commitCancel() throws TwainIOException {
        if (this.isCancelled && this.source.getState() == 6) {
            throw new TwainUserCancelException();
        }
    }

    public void finish() throws TwainIOException {
    }

    public void cancel() throws TwainIOException {
    }

    public void cleanup() throws TwainIOException {
    }

    public static class MemoryTransfer
    extends TwainTransfer {
        private byte[] imx = new byte[jtwain.getPtrSize() == 4 ? 38 : 42];
        private Info info;
        protected int minBufSize = -1;
        protected int maxBufSize = -1;
        protected int preferredSize = -1;

        public MemoryTransfer(TwainSource twainSource) {
            super(twainSource);
        }

        protected void retrieveBufferSizes() throws TwainIOException {
            byte[] byArray = new byte[12];
            jtwain.setINT32(byArray, 0, this.minBufSize);
            jtwain.setINT32(byArray, 4, this.maxBufSize);
            jtwain.setINT32(byArray, 8, this.preferredSize);
            this.source.call(1, 6, 1, byArray);
            this.minBufSize = jtwain.getINT32(byArray, 0);
            this.maxBufSize = jtwain.getINT32(byArray, 4);
            this.preferredSize = jtwain.getINT32(byArray, 8);
        }

        public void initiate() throws TwainIOException {
            super.initiate();
            this.retrieveBufferSizes();
            jtwain.nnew(this.imx, this.preferredSize);
            byte[] byArray = new byte[this.preferredSize];
            this.info = new Info(this.imx, byArray);
            while (true) {
                this.source.call(2, 259, 1, this.imx);
                int n = jtwain.getINT32(this.imx, 22);
                int n2 = jtwain.ncopy(byArray, this.imx, n);
                if (n2 != n) continue;
                jtwain.transferMemoryBuffer(this.info);
            }
        }

        public void finish() throws TwainIOException {
            int n = jtwain.getINT32(this.imx, 22);
            int n2 = jtwain.ncopy(this.info.getBuffer(), this.imx, n);
            if (n2 == n) {
                jtwain.transferMemoryBuffer(this.info);
            }
        }

        public void cleanup() throws TwainIOException {
            jtwain.ndelete(this.imx);
        }

        public static class Info {
            private byte[] imx;
            private byte[] buf;
            private int len;

            Info(byte[] byArray, byte[] byArray2) {
                this.imx = byArray;
                this.buf = byArray2;
            }

            public byte[] getBuffer() {
                return this.buf;
            }

            public int getCompression() {
                return jtwain.getINT16(this.imx, 0);
            }

            public int getBytesPerRow() {
                return jtwain.getINT32(this.imx, 2);
            }

            public int getWidth() {
                return jtwain.getINT32(this.imx, 6);
            }

            public int getHeight() {
                return jtwain.getINT32(this.imx, 10);
            }

            public int getLeft() {
                return jtwain.getINT32(this.imx, 14);
            }

            public int getTop() {
                return jtwain.getINT32(this.imx, 18);
            }

            public int getLength() {
                return jtwain.getINT32(this.imx, 22);
            }

            public int getMemFlags() {
                return jtwain.getINT32(this.imx, 26);
            }

            public int getMemLength() {
                return jtwain.getINT32(this.imx, 30);
            }

            public long getMemPtr() {
                return jtwain.getPtr(this.imx, 34);
            }

            public String toString() {
                String string = this.getClass().getName() + "\n";
                string = string + "\tcompression = " + this.getCompression() + "\n";
                string = string + "\tbytes per row = " + this.getBytesPerRow() + "\n";
                string = string + "\ttop = " + this.getTop() + " left = " + this.getLeft() + " width = " + this.getWidth() + " height = " + this.getHeight() + "\n";
                string = string + "\tbytes = " + this.getLength() + "\n";
                string = string + "\tmemory flags   = 0x" + Integer.toHexString(this.getMemFlags()) + "\n";
                string = string + "\tmemory length  = " + this.getMemLength() + "\n";
                string = string + "\tmemory pointer = 0x" + Long.toHexString(this.getMemPtr()) + "\n";
                return string;
            }
        }
    }

    public static class FileTransfer
    extends TwainTransfer {
        protected File file = null;

        public FileTransfer(TwainSource twainSource) {
            super(twainSource);
        }

        protected int getImageFileFormat() {
            return this.source.getImageFileFormat();
        }

        public void setFile(File file) {
            this.file = file;
        }

        public File getFile() {
            if (this.file == null) {
                String string = TwainConstants.ImageFileFormatExts[this.getImageFileFormat()];
                try {
                    File file = new File(System.getProperty("user.home"), "mmsc/tmp");
                    file.mkdirs();
                    this.file = File.createTempFile("mmsctwain", string, file);
                }
                catch (Exception exception) {
                    this.file = new File("c:\\mmsctwain." + string);
                }
            }
            return this.file;
        }

        public void initiate() throws TwainIOException {
            super.initiate();
            String string = this.getFile().getPath();
            int n = this.getImageFileFormat();
            byte[] byArray = new byte[260];
            jtwain.setString(byArray, 0, string);
            jtwain.setINT16(byArray, 256, n);
            jtwain.setINT16(byArray, 258, 0);
            this.source.call(1, 7, 6, byArray);
            this.source.call(2, 261, 1, null);
        }

        public void finish() throws TwainIOException {
            jtwain.transferFileImage(this.file);
        }

        public void cancel() throws TwainIOException {
            if (this.file != null && this.file.exists()) {
                this.file.delete();
            }
        }

        public void cleanup() throws TwainIOException {
            this.setFile(null);
        }
    }

    public static class NativeTransfer
    extends TwainTransfer {
        private byte[] imageHandle = new byte[jtwain.getPtrSize()];

        public NativeTransfer(TwainSource twainSource) {
            super(twainSource);
        }

        public void initiate() throws TwainIOException {
            super.initiate();
            this.source.call(2, 260, 1, this.imageHandle);
        }

        public void finish() throws TwainIOException {
            long l = jtwain.getPtr(this.imageHandle, 0);
            jtwain.transferNativeImage(l);
        }
    }
}

