/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Vector;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.concurrent.TimeUnit;
import uk.co.mmscomputing.device.twain.TwainConstants;
import uk.co.mmscomputing.device.twain.TwainException;
import uk.co.mmscomputing.device.twain.TwainIOException;
import uk.co.mmscomputing.device.twain.TwainIdentity;
import uk.co.mmscomputing.device.twain.TwainNativeLoadStrategySingleton;
import uk.co.mmscomputing.device.twain.TwainScanner;
import uk.co.mmscomputing.device.twain.TwainSource;
import uk.co.mmscomputing.device.twain.TwainSourceManager;
import uk.co.mmscomputing.device.twain.TwainTransfer;

public class jtwain
implements TwainConstants {
    private static boolean installed;
    private static Thread nativeThread;
    private static TwainSourceManager sourceManager;
    private static WeakReference scanner;
    private static int ptrSize;
    private static long ptrCallback;
    static /* synthetic */ Class class$uk$co$mmscomputing$device$twain$jtwain;
    static /* synthetic */ Class class$uk$co$mmscomputing$device$twain$TwainSource;

    private static native long ninitLib();

    private static native void nstart();

    private static native int ngetPtrSize();

    static int getPtrSize() {
        return ptrSize;
    }

    private static native void ntrigger(Object var0, int var1);

    private static native int ncallSourceManager(int var0, int var1, int var2, byte[] var3) throws TwainException;

    static native byte[] ngetContainer(byte[] var0);

    static native void nsetContainer(byte[] var0, byte[] var1);

    static native void nfreeContainer(byte[] var0);

    private static native int ncallSource(byte[] var0, int var1, int var2, int var3, byte[] var4) throws TwainException;

    private static native long ngetCallBackMethod();

    static long getCallBackMethod() {
        return ptrCallback;
    }

    private static native Object ntransferImage(long var0);

    static native void nnew(byte[] var0, int var1);

    static native int ncopy(byte[] var0, byte[] var1, int var2);

    static native void ndelete(byte[] var0);

    public static boolean isInstalled() {
        return installed;
    }

    static int getINT16(byte[] byArray, int n) {
        return byArray[n++] & 0xFF | byArray[n] << 8;
    }

    static void setINT16(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)n2;
        byArray[n++] = (byte)(n2 >> 8);
    }

    static int getINT32(byte[] byArray, int n) {
        return byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | byArray[n] << 24;
    }

    static void setINT32(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)n2;
        byArray[n++] = (byte)(n2 >> 8);
        byArray[n++] = (byte)(n2 >> 16);
        byArray[n++] = (byte)(n2 >> 24);
    }

    static long getINT64(byte[] byArray, int n) {
        return (long)byArray[n++] & 0xFFL | ((long)byArray[n++] & 0xFFL) << 8 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 56;
    }

    static void setINT64(byte[] byArray, int n, long l) {
        byArray[n++] = (byte)l;
        byArray[n++] = (byte)(l >> 8);
        byArray[n++] = (byte)(l >> 16);
        byArray[n++] = (byte)(l >> 24);
        byArray[n++] = (byte)(l >> 32);
        byArray[n++] = (byte)(l >> 40);
        byArray[n++] = (byte)(l >> 48);
        byArray[n++] = (byte)(l >> 56);
    }

    static long getPtr(byte[] byArray, int n) {
        if (ptrSize == 8) {
            return jtwain.getINT64(byArray, n);
        }
        return jtwain.getINT32(byArray, n);
    }

    static int setPtr(byte[] byArray, int n, long l) {
        if (ptrSize == 8) {
            jtwain.setINT64(byArray, n, l);
            return 8;
        }
        jtwain.setINT32(byArray, n, (int)l);
        return 4;
    }

    static double getFIX32(byte[] byArray, int n) {
        int n2 = byArray[n++] & 0xFF | byArray[n++] << 8;
        int n3 = byArray[n++] & 0xFF | (byArray[n] & 0xFF) << 8;
        return (double)n2 + (double)n3 / 65536.0;
    }

    static void setFIX32(byte[] byArray, int n, double d) {
        int n2 = (int)(d * 65536.0 + (d < 0.0 ? -0.5 : 0.5));
        jtwain.setINT16(byArray, n, n2 >> 16);
        jtwain.setINT16(byArray, n + 2, n2 & 0xFFFF);
    }

    static void setString(byte[] byArray, int n, String string) {
        System.arraycopy(string.getBytes(), 0, byArray, 0, string.length());
    }

    static int callSourceManager(int n, int n2, int n3, byte[] byArray) throws TwainIOException {
        if (Thread.currentThread() != nativeThread) {
            throw new TwainIOException("Call twain source manager only from within native thread.");
        }
        try {
            return jtwain.ncallSourceManager(n, n2, n3, byArray);
        }
        catch (TwainException twainException) {
            installed = false;
            throw twainException;
        }
    }

    static int callSource(byte[] byArray, int n, int n2, int n3, byte[] byArray2) throws TwainIOException {
        if (Thread.currentThread() != nativeThread) {
            throw new TwainIOException("Call twain source only from within native thread.");
        }
        try {
            return jtwain.ncallSource(byArray, n, n2, n3, byArray2);
        }
        catch (TwainException twainException) {
            installed = false;
            throw twainException;
        }
    }

    public static TwainSourceManager getSourceManager() throws TwainIOException {
        try {
            while (sourceManager == null && installed) {
                Thread.currentThread();
                Thread.sleep(100L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!installed) {
            throw new TwainIOException("Cannot load Twain Source Manager.");
        }
        return sourceManager;
    }

    public static TwainSource getSource() throws TwainIOException {
        return jtwain.getSourceManager().getSource();
    }

    private static void trigger(Object object, int n) {
        try {
            while (sourceManager == null && installed) {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            if (installed) {
                jtwain.ntrigger(object, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void callSetSource(Object object) {
        jtwain.trigger(object, 0);
    }

    public static void setScanner(TwainScanner twainScanner) {
        scanner = new WeakReference<TwainScanner>(twainScanner);
    }

    private static TwainScanner getScanner() {
        return (TwainScanner)scanner.get();
    }

    public static void select(TwainScanner twainScanner) throws TwainIOException {
        jtwain.setScanner(twainScanner);
        TwainSourceManager twainSourceManager = jtwain.getSourceManager();
        twainSourceManager.getSource().checkState(3);
        jtwain.trigger(twainScanner, 1);
    }

    static void getIdentities(TwainScanner twainScanner, Vector vector) throws TwainIOException {
        jtwain.setScanner(twainScanner);
        TwainSourceManager twainSourceManager = jtwain.getSourceManager();
        twainSourceManager.getSource().checkState(3);
        Semaphore semaphore = new Semaphore(0, true);
        Object[] objectArray = new Object[]{vector, semaphore};
        jtwain.trigger(objectArray, 2);
        try {
            semaphore.tryAcquire(3000L, TimeUnit.MILLISECONDS);
            if (vector.isEmpty() && objectArray[1] != null) {
                throw new TwainIOException((class$uk$co$mmscomputing$device$twain$jtwain == null ? (class$uk$co$mmscomputing$device$twain$jtwain = jtwain.class$("uk.co.mmscomputing.device.twain.jtwain")) : class$uk$co$mmscomputing$device$twain$jtwain).getName() + ".getIdentities\n\tCould not retrieve device names. Request timed out.");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new TwainIOException((class$uk$co$mmscomputing$device$twain$jtwain == null ? (class$uk$co$mmscomputing$device$twain$jtwain = jtwain.class$("uk.co.mmscomputing.device.twain.jtwain")) : class$uk$co$mmscomputing$device$twain$jtwain).getName() + ".getIdentities\n\tCould not retrieve device names. Request was interrupted.");
        }
    }

    public static void select(TwainScanner twainScanner, String string) throws TwainIOException {
        jtwain.setScanner(twainScanner);
        TwainSourceManager twainSourceManager = jtwain.getSourceManager();
        twainSourceManager.getSource().checkState(3);
        jtwain.trigger(string, 3);
    }

    public static void acquire(TwainScanner twainScanner) throws TwainIOException {
        jtwain.setScanner(twainScanner);
        TwainSourceManager twainSourceManager = jtwain.getSourceManager();
        twainSourceManager.getSource().checkState(3);
        jtwain.trigger(twainScanner, 4);
    }

    public static void setCancel(TwainScanner twainScanner, boolean bl) throws TwainIOException {
        jtwain.getSourceManager().getSource().setCancel(bl);
    }

    private static Method getMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        if (clazz == null) {
            throw new NoSuchMethodException();
        }
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return jtwain.getMethod(clazz.getSuperclass(), string, classArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cbexecute(Object object, int n) {
        try {
            switch (n) {
                case 0: {
                    Class<?> clazz = object.getClass();
                    try {
                        TwainSource twainSource = sourceManager.getSource();
                        Method method = jtwain.getMethod(clazz, "setSource", new Class[]{class$uk$co$mmscomputing$device$twain$TwainSource == null ? (class$uk$co$mmscomputing$device$twain$TwainSource = jtwain.class$("uk.co.mmscomputing.device.twain.TwainSource")) : class$uk$co$mmscomputing$device$twain$TwainSource});
                        method.invoke(object, twainSource);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    break;
                }
                case 1: {
                    sourceManager.selectSource();
                    break;
                }
                case 2: {
                    Object[] objectArray = (Object[])object;
                    Vector vector = (Vector)objectArray[0];
                    Semaphore semaphore = (Semaphore)objectArray[1];
                    sourceManager.getIdentities(vector);
                    objectArray[1] = null;
                    semaphore.release();
                    break;
                }
                case 3: {
                    String string = (String)object;
                    sourceManager.selectSource(string);
                    break;
                }
                case 4: {
                    TwainSource twainSource = sourceManager.openSource();
                    try {
                        twainSource.enable();
                        break;
                    }
                    finally {
                        twainSource.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            jtwain.signalException(throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    private static int cbhandleGetMessage(long l) {
        try {
            return sourceManager.getSource().handleGetMessage(l);
        }
        catch (Throwable throwable) {
            jtwain.signalException(throwable.getMessage());
            throwable.printStackTrace();
            return 5;
        }
    }

    private static int cbmethod20(byte[] byArray, byte[] byArray2, int n, int n2, int n3, long l) {
        try {
            TwainIdentity twainIdentity = new TwainIdentity(sourceManager, byArray);
            TwainSource twainSource = sourceManager.getSource();
            if (twainIdentity.getId() != twainSource.getId()) {
                return 1;
            }
            return twainSource.callback(n, n2, n3, l);
        }
        catch (Throwable throwable) {
            jtwain.signalException(throwable.getMessage());
            throwable.printStackTrace();
            return 1;
        }
    }

    static void signalStateChange(TwainSource twainSource) {
        TwainScanner twainScanner = jtwain.getScanner();
        if (twainScanner != null) {
            twainScanner.setState(twainSource);
        }
    }

    static void signalException(String string) {
        TwainScanner twainScanner = jtwain.getScanner();
        if (twainScanner != null) {
            twainScanner.signalException(string);
        }
    }

    static void negotiateCapabilities(TwainSource twainSource) {
        TwainScanner twainScanner = jtwain.getScanner();
        if (twainScanner != null) {
            twainScanner.negotiateCapabilities(twainSource);
        }
    }

    static void transferNativeImage(long l) {
        TwainScanner twainScanner;
        BufferedImage bufferedImage = (BufferedImage)jtwain.ntransferImage(l);
        if (bufferedImage != null && (twainScanner = jtwain.getScanner()) != null) {
            twainScanner.setImage(bufferedImage);
        }
    }

    static void transferFileImage(File file) {
        TwainScanner twainScanner;
        if (file != null && (twainScanner = jtwain.getScanner()) != null) {
            twainScanner.setImage(file);
        }
    }

    static void transferMemoryBuffer(TwainTransfer.MemoryTransfer.Info info) {
        TwainScanner twainScanner = jtwain.getScanner();
        if (twainScanner != null) {
            twainScanner.setImageBuffer(info);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ptrSize = 0;
        ptrCallback = 0L;
        installed = TwainNativeLoadStrategySingleton.getInstance().getNativeLoadStrategy().load(class$uk$co$mmscomputing$device$twain$jtwain == null ? (class$uk$co$mmscomputing$device$twain$jtwain = jtwain.class$("uk.co.mmscomputing.device.twain.jtwain")) : class$uk$co$mmscomputing$device$twain$jtwain, "jtwain");
        if (installed) {
            ptrSize = jtwain.ngetPtrSize();
            ptrCallback = jtwain.ngetCallBackMethod();
            nativeThread = new Thread(){

                public void run() {
                    try {
                        long l = jtwain.ninitLib();
                        if (l != 0L) {
                            sourceManager = new TwainSourceManager(l);
                            jtwain.nstart();
                        }
                    }
                    catch (Throwable throwable) {
                        System.err.println("uk.co.mmscomputing.device.twain.jtwain\t\n" + throwable.getMessage());
                        System.err.println(throwable);
                        throwable.printStackTrace();
                    }
                    installed = false;
                }
            };
            nativeThread.start();
        }
    }
}

