/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.bmp;

import java.awt.image.IndexColorModel;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import uk.co.mmscomputing.imageio.bmp.BMPConstants;

public class BMPMetadata
extends IIOMetadata
implements BMPConstants {
    private static final String formatName = "javax_imageio_bmp_1.0";
    private int width;
    private int height;
    private int bitsPerPixel;
    private int compression;
    private int imageSize;
    private int xPixelsPerMeter = 2953;
    private int yPixelsPerMeter = 2953;
    private int colorsUsed;
    private int colorsImportant;
    private int redMask;
    private int greenMask;
    private int blueMask;
    private IndexColorModel icm;

    public BMPMetadata() {
        super(true, formatName, "uk.co.mmscomputing.imageio.bmp.BMPMetadata", null, null);
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setBitsPerPixel(int n) {
        this.bitsPerPixel = n;
    }

    public void setCompression(int n) {
        this.compression = n;
    }

    public void setImageSize(int n) {
        this.imageSize = n;
    }

    public void setXPixelsPerMeter(int n) {
        this.xPixelsPerMeter = n;
    }

    public void setYPixelsPerMeter(int n) {
        this.yPixelsPerMeter = n;
    }

    public void setXDotsPerInch(int n) {
        this.xPixelsPerMeter = (int)Math.round((double)n * 1000.0 / 25.4);
    }

    public void setYDotsPerInch(int n) {
        this.yPixelsPerMeter = (int)Math.round((double)n * 1000.0 / 25.4);
    }

    public void setColorsUsed(int n) {
        this.colorsUsed = n;
    }

    public void setColorsImportant(int n) {
        this.colorsImportant = n;
    }

    public void setRedMask(int n) {
        this.redMask = n;
    }

    public void setGreenMask(int n) {
        this.greenMask = n;
    }

    public void setBlueMask(int n) {
        this.blueMask = n;
    }

    public void setIndexColorModel(IndexColorModel indexColorModel) {
        if (indexColorModel != null) {
            this.colorsUsed = indexColorModel.getMapSize();
        }
        this.icm = indexColorModel;
    }

    public int getXPixelsPerMeter() {
        return this.xPixelsPerMeter;
    }

    public int getYPixelsPerMeter() {
        return this.yPixelsPerMeter;
    }

    public int getXDotsPerInch() {
        return (int)Math.round((double)this.xPixelsPerMeter * 25.4 / 1000.0);
    }

    public int getYDotsPerInch() {
        return (int)Math.round((double)this.yPixelsPerMeter * 25.4 / 1000.0);
    }

    public IndexColorModel getIndexColorModel() {
        return this.icm;
    }

    public boolean isReadOnly() {
        return false;
    }

    public Node getAsTree(String string) {
        if (string.equals(formatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException(this.getClass().getName() + ".mergeTree:\n\tUnknown format: " + string);
    }

    public void mergeTree(String string, Node node) {
        throw new IllegalStateException(this.getClass().getName() + ".mergeTree:\n\tFunction not supported.");
    }

    public void reset() {
        throw new IllegalStateException(this.getClass().getName() + ".reset:\n\tFunction not supported.");
    }

    private Node getNativeTree() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(formatName);
        this.addChildNode(iIOMetadataNode, "BMPVersion", "BMP v. 3.x");
        this.addChildNode(iIOMetadataNode, "Width", new Integer(this.width));
        this.addChildNode(iIOMetadataNode, "Height", new Integer(this.height));
        this.addChildNode(iIOMetadataNode, "BitsPerPixel", new Integer(this.bitsPerPixel));
        this.addChildNode(iIOMetadataNode, "Compression", new Integer(this.compression));
        this.addChildNode(iIOMetadataNode, "ImageSize", new Integer(this.imageSize));
        IIOMetadataNode iIOMetadataNode2 = this.addChildNode(iIOMetadataNode, "PixelsPerMeter", null);
        this.addChildNode(iIOMetadataNode2, "X", new Integer(this.xPixelsPerMeter));
        this.addChildNode(iIOMetadataNode2, "Y", new Integer(this.yPixelsPerMeter));
        this.addChildNode(iIOMetadataNode, "ColorsUsed", new Integer(this.colorsUsed));
        this.addChildNode(iIOMetadataNode, "ColorsImportant", new Integer(this.colorsImportant));
        if (this.icm != null) {
            iIOMetadataNode2 = this.addChildNode(iIOMetadataNode, "Palette", null);
            for (int i = 0; i < this.colorsUsed; ++i) {
                IIOMetadataNode iIOMetadataNode3 = this.addChildNode(iIOMetadataNode2, "PaletteEntry", null);
                this.addChildNode(iIOMetadataNode3, "Red", new Byte((byte)this.icm.getRed(i)));
                this.addChildNode(iIOMetadataNode3, "Green", new Byte((byte)this.icm.getGreen(i)));
                this.addChildNode(iIOMetadataNode3, "Blue", new Byte((byte)this.icm.getBlue(i)));
            }
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        if (this.icm != null) {
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Palette");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            for (int i = 0; i < this.colorsUsed; ++i) {
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("PaletteEntry");
                iIOMetadataNode2.appendChild(iIOMetadataNode3);
                iIOMetadataNode3.setAttribute("index", "" + i);
                iIOMetadataNode3.setAttribute("red", "" + this.icm.getRed(i));
                iIOMetadataNode3.setAttribute("green", "" + this.icm.getGreen(i));
                iIOMetadataNode3.setAttribute("blue", "" + this.icm.getBlue(i));
                iIOMetadataNode3.setAttribute("alpha", "255");
            }
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
        iIOMetadataNode2.setAttribute("value", BMPConstants.compressionTypeNames[this.compression]);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    private String countBits(int n) {
        int n2 = 0;
        while (n > 0) {
            if ((n & 1) == 1) {
                ++n2;
            }
            n >>>= 1;
        }
        return n2 == 0 ? "" : "" + n2;
    }

    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        String string = "";
        if (this.bitsPerPixel == 24) {
            string = "8 8 8";
        } else if (this.bitsPerPixel == 16 || this.bitsPerPixel == 32) {
            string = string + this.countBits(this.redMask) + " " + this.countBits(this.greenMask) + " " + this.countBits(this.blueMask);
        } else if (this.bitsPerPixel <= 8) {
            string = string + this.bitsPerPixel;
        }
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("BitsPerSample");
        iIOMetadataNode2.setAttribute("value", string);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        if ((double)this.yPixelsPerMeter > 0.0 && (double)this.xPixelsPerMeter > 0.0) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
            double d = this.yPixelsPerMeter / this.xPixelsPerMeter;
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("PixelAspectRatio");
            iIOMetadataNode2.setAttribute("value", "" + d);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            d = 1000.0 / (double)this.xPixelsPerMeter;
            iIOMetadataNode2 = new IIOMetadataNode("HorizontalPhysicalPixelSpacing");
            iIOMetadataNode2.setAttribute("value", "" + d);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            d = 1000.0 / (double)this.yPixelsPerMeter;
            iIOMetadataNode2 = new IIOMetadataNode("VerticalPhysicalPixelSpacing");
            iIOMetadataNode2.setAttribute("value", "" + d);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            return iIOMetadataNode;
        }
        return null;
    }

    private String objectToString(Object object) {
        return object.toString();
    }

    private IIOMetadataNode addChildNode(IIOMetadataNode iIOMetadataNode, String string, Object object) {
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode(string);
        if (object != null) {
            iIOMetadataNode2.setUserObject(object);
            iIOMetadataNode2.setNodeValue(this.objectToString(object));
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode2;
    }
}

